/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.FlowException;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.ResponseInstruction;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractor;

public class FlowRequestHandler {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$executor$support$FlowRequestHandler == null ? (class$org$springframework$webflow$executor$support$FlowRequestHandler = FlowRequestHandler.class$("org.springframework.webflow.executor.support.FlowRequestHandler")) : class$org$springframework$webflow$executor$support$FlowRequestHandler));
    private FlowExecutor flowExecutor;
    private FlowExecutorArgumentExtractor argumentExtractor;
    static /* synthetic */ Class class$org$springframework$webflow$executor$support$FlowRequestHandler;

    public FlowRequestHandler(FlowExecutor flowExecutor) {
        this(flowExecutor, new FlowExecutorArgumentExtractor());
    }

    public FlowRequestHandler(FlowExecutor flowExecutor, FlowExecutorArgumentExtractor argumentExtractor) {
        Assert.notNull((Object)flowExecutor, (String)"The flow executor is required");
        Assert.notNull((Object)argumentExtractor, (String)"The flow executor argument extractor is required");
        this.flowExecutor = flowExecutor;
        this.argumentExtractor = argumentExtractor;
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public FlowExecutorArgumentExtractor getArgumentExtractor() {
        return this.argumentExtractor;
    }

    public ResponseInstruction handleFlowRequest(ExternalContext context) throws FlowException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Request initiated by " + context));
        }
        if (this.argumentExtractor.isFlowExecutionKeyPresent(context)) {
            String flowExecutionKey = this.argumentExtractor.extractFlowExecutionKey(context);
            if (this.argumentExtractor.isEventIdPresent(context)) {
                String eventId = this.argumentExtractor.extractEventId(context);
                ResponseInstruction response = this.flowExecutor.signalEvent(eventId, flowExecutionKey, context);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Returning [resume] " + response));
                }
                return response;
            }
            ResponseInstruction response = this.flowExecutor.refresh(flowExecutionKey, context);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Returning [refresh] " + response));
            }
            return response;
        }
        String flowId = this.argumentExtractor.extractFlowId(context);
        ResponseInstruction response = this.flowExecutor.launch(flowId, context);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning [launch] " + response));
        }
        return response;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

