/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.support;

import org.springframework.util.StringUtils;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.FlowExecutionContext;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractor;
import org.springframework.webflow.support.FlowRedirect;

public class RequestPathFlowExecutorArgumentExtractor
extends FlowExecutorArgumentExtractor {
    private static final char PATH_SEPARATOR_CHARACTER = '/';

    public boolean isFlowIdPresent(ExternalContext context) {
        String requestPathInfo = this.getRequestPathInfo(context);
        boolean hasFileName = StringUtils.hasText((String)WebUtils.extractFilenameFromUrlPath((String)requestPathInfo));
        return hasFileName || super.isFlowIdPresent(context);
    }

    public String extractFlowId(ExternalContext context) {
        String requestPathInfo = this.getRequestPathInfo(context);
        String extractedFilename = WebUtils.extractFilenameFromUrlPath((String)requestPathInfo);
        return StringUtils.hasText((String)extractedFilename) ? extractedFilename : super.extractFlowId(context);
    }

    public String createFlowUrl(FlowRedirect flowRedirect, ExternalContext context) {
        StringBuffer flowUrl = new StringBuffer();
        flowUrl.append(context.getContextPath());
        flowUrl.append(context.getDispatcherPath());
        flowUrl.append('/');
        flowUrl.append(flowRedirect.getFlowId());
        if (!flowRedirect.getInput().isEmpty()) {
            flowUrl.append('?');
            this.appendQueryParameters(flowRedirect.getInput(), flowUrl);
        }
        return flowUrl.toString();
    }

    public String createFlowExecutionUrl(String flowExecutionKey, FlowExecutionContext flowExecution, ExternalContext context) {
        StringBuffer flowExecutionUrl = new StringBuffer();
        flowExecutionUrl.append(context.getContextPath());
        flowExecutionUrl.append(context.getDispatcherPath());
        flowExecutionUrl.append('/');
        flowExecutionUrl.append(flowExecution.getActiveSession().getFlow().getId());
        flowExecutionUrl.append('?');
        this.appendQueryParameter(this.getFlowExecutionKeyParameterName(), flowExecutionKey, flowExecutionUrl);
        return flowExecutionUrl.toString();
    }

    private String getRequestPathInfo(ExternalContext context) {
        String requestPathInfo = context.getRequestPathInfo();
        return requestPathInfo != null ? requestPathInfo : "";
    }
}

