/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.registry;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.webflow.builder.BeanInvokingActionFactory;
import org.springframework.webflow.builder.FlowArtifactFactory;
import org.springframework.webflow.builder.FlowServiceLocator;
import org.springframework.webflow.registry.DefaultFlowServiceLocator;
import org.springframework.webflow.registry.FlowRegistry;
import org.springframework.webflow.registry.FlowRegistryImpl;

public abstract class AbstractFlowRegistryFactoryBean
implements FactoryBean,
BeanFactoryAware,
ResourceLoaderAware,
InitializingBean {
    private FlowRegistryImpl flowRegistry = new FlowRegistryImpl();
    private FlowServiceLocator flowServiceLocator;
    private FlowArtifactFactory flowArtifactFactory;
    private BeanInvokingActionFactory beanInvokingActionFactory;
    private ExpressionParser expressionParser;
    private ConversionService conversionService;
    private ResourceLoader resourceLoader;
    private BeanFactory beanFactory;
    static /* synthetic */ Class class$org$springframework$webflow$registry$FlowRegistry;

    public void setParent(FlowRegistry parent) {
        this.flowRegistry.setParent(parent);
    }

    public void setFlowArtifactFactory(FlowArtifactFactory flowArtifactFactory) {
        this.flowArtifactFactory = flowArtifactFactory;
    }

    public void setBeanInvokingActionFactory(BeanInvokingActionFactory beanInvokingActionFactory) {
        this.beanInvokingActionFactory = beanInvokingActionFactory;
    }

    public void setExpressionParser(ExpressionParser expressionParser) {
        this.expressionParser = expressionParser;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        this.flowServiceLocator = this.createFlowServiceLocator();
    }

    protected FlowRegistry getFlowRegistry() {
        return this.flowRegistry;
    }

    public FlowServiceLocator getFlowServiceLocator() {
        return this.flowServiceLocator;
    }

    public Object getObject() throws Exception {
        return this.populateFlowRegistry();
    }

    public FlowRegistry populateFlowRegistry() {
        this.doPopulate(this.getFlowRegistry());
        return this.getFlowRegistry();
    }

    protected abstract void doPopulate(FlowRegistry var1);

    public Class getObjectType() {
        return class$org$springframework$webflow$registry$FlowRegistry == null ? (class$org$springframework$webflow$registry$FlowRegistry = AbstractFlowRegistryFactoryBean.class$("org.springframework.webflow.registry.FlowRegistry")) : class$org$springframework$webflow$registry$FlowRegistry;
    }

    public boolean isSingleton() {
        return true;
    }

    protected FlowServiceLocator createFlowServiceLocator() {
        DefaultFlowServiceLocator serviceLocator = new DefaultFlowServiceLocator(this.flowRegistry, this.beanFactory);
        if (this.flowArtifactFactory != null) {
            serviceLocator.setFlowArtifactFactory(this.flowArtifactFactory);
        }
        if (this.beanInvokingActionFactory != null) {
            serviceLocator.setBeanInvokingActionFactory(this.beanInvokingActionFactory);
        }
        if (this.expressionParser != null) {
            serviceLocator.setExpressionParser(this.expressionParser);
        }
        if (this.conversionService != null) {
            serviceLocator.setConversionService(this.conversionService);
        }
        if (this.resourceLoader != null) {
            serviceLocator.setResourceLoader(this.resourceLoader);
        }
        return serviceLocator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

