/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.registry;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.util.Assert;
import org.springframework.webflow.Flow;
import org.springframework.webflow.builder.BaseFlowServiceLocator;
import org.springframework.webflow.builder.FlowArtifactLookupException;
import org.springframework.webflow.execution.FlowLocatorException;
import org.springframework.webflow.registry.FlowRegistry;

public class DefaultFlowServiceLocator
extends BaseFlowServiceLocator {
    private FlowRegistry subflowRegistry;
    private BeanFactory beanFactory;
    static /* synthetic */ Class class$org$springframework$webflow$Flow;

    public DefaultFlowServiceLocator(FlowRegistry subflowRegistry, BeanFactory beanFactory) {
        Assert.notNull((Object)subflowRegistry, (String)"The subflow registry is required");
        Assert.notNull((Object)beanFactory, (String)"The bean factory is required");
        this.subflowRegistry = subflowRegistry;
        this.beanFactory = beanFactory;
    }

    protected void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public FlowRegistry getSubflowRegistry() {
        return this.subflowRegistry;
    }

    public Flow getSubflow(String id) throws FlowArtifactLookupException {
        try {
            return this.subflowRegistry.getFlow(id);
        }
        catch (FlowLocatorException e) {
            throw new FlowArtifactLookupException(id, class$org$springframework$webflow$Flow == null ? (class$org$springframework$webflow$Flow = DefaultFlowServiceLocator.class$("org.springframework.webflow.Flow")) : class$org$springframework$webflow$Flow, "Could not locate subflow definition with id '" + id + "'", (Throwable)((Object)e));
        }
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

