/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.registry;

import java.io.Serializable;
import org.springframework.core.io.Resource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.AttributeCollection;
import org.springframework.webflow.CollectionUtils;
import org.springframework.webflow.UnmodifiableAttributeMap;

public class ExternalizedFlowDefinition
implements Serializable {
    private String id;
    private UnmodifiableAttributeMap attributes;
    private Resource location;

    public ExternalizedFlowDefinition(Resource location) {
        Assert.notNull((Object)location, (String)"The location of the externalized flow definition is required");
        this.init(this.stripExtension(location.getFilename()), location, null);
    }

    public ExternalizedFlowDefinition(String id, Resource location) {
        this.init(id, location, null);
    }

    public ExternalizedFlowDefinition(String id, Resource location, AttributeCollection attributes) {
        this.init(id, location, attributes);
    }

    public String getId() {
        return this.id;
    }

    public Resource getLocation() {
        return this.location;
    }

    public UnmodifiableAttributeMap getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExternalizedFlowDefinition)) {
            return false;
        }
        ExternalizedFlowDefinition other = (ExternalizedFlowDefinition)o;
        return this.id.equals(other.id) && this.location.equals(other.location);
    }

    public int hashCode() {
        return this.id.hashCode() + this.location.hashCode();
    }

    private void init(String id, Resource location, AttributeCollection attributes) {
        Assert.hasText((String)id, (String)"The id of the externalized flow definition is required");
        Assert.notNull((Object)location, (String)"The location of the externalized flow definition is required");
        this.id = id;
        this.location = location;
        this.attributes = attributes != null ? attributes.unmodifiable() : CollectionUtils.EMPTY_ATTRIBUTE_MAP;
    }

    private String stripExtension(String fileName) {
        int extensionIndex = fileName.lastIndexOf(46);
        if (extensionIndex != -1) {
            return fileName.substring(0, extensionIndex);
        }
        return fileName;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.id).append("location", (Object)this.location).append("attributes", (Object)this.attributes).toString();
    }
}

