/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.registry;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.builder.FlowBuilder;
import org.springframework.webflow.builder.FlowServiceLocator;
import org.springframework.webflow.registry.ExternalizedFlowDefinition;
import org.springframework.webflow.registry.FlowRegistrarSupport;
import org.springframework.webflow.registry.FlowRegistry;

public abstract class ExternalizedFlowRegistrar
extends FlowRegistrarSupport {
    private Set flowLocations = new HashSet();
    private Set flowDefinitions = new HashSet();

    public void setFlowLocations(Resource[] flowLocations) {
        this.flowLocations = new HashSet<Resource>(Arrays.asList(flowLocations));
    }

    public void setFlowDefinitions(ExternalizedFlowDefinition[] flowDefinitions) {
        this.flowDefinitions = new HashSet<ExternalizedFlowDefinition>(Arrays.asList(flowDefinitions));
    }

    public boolean addFlowLocation(Resource flowLocation) {
        return this.flowLocations.add(flowLocation);
    }

    public boolean addFlowLocations(Resource[] flowLocations) {
        if (flowLocations == null) {
            return false;
        }
        return this.flowLocations.addAll(Arrays.asList(flowLocations));
    }

    public boolean addFlowDefinition(ExternalizedFlowDefinition flowDefinition) {
        return this.flowDefinitions.add(flowDefinition);
    }

    public boolean addFlowDefinitions(ExternalizedFlowDefinition[] flowDefinitions) {
        if (flowDefinitions == null) {
            return false;
        }
        return this.flowDefinitions.addAll(Arrays.asList(flowDefinitions));
    }

    public void registerFlows(FlowRegistry registry, FlowServiceLocator flowServiceLocator) {
        this.processFlowLocations(registry, flowServiceLocator);
        this.processFlowDefinitions(registry, flowServiceLocator);
    }

    private void processFlowLocations(FlowRegistry registry, FlowServiceLocator flowServiceLocator) {
        Iterator it = this.flowLocations.iterator();
        while (it.hasNext()) {
            Resource location = (Resource)it.next();
            if (!this.isFlowDefinition(location)) continue;
            ExternalizedFlowDefinition definition = this.createFlowDefinition(location);
            FlowBuilder builder = this.createFlowBuilder(definition.getLocation(), flowServiceLocator);
            this.registerFlow(definition, registry, builder);
        }
    }

    private void processFlowDefinitions(FlowRegistry registry, FlowServiceLocator flowServiceLocator) {
        Iterator it = this.flowDefinitions.iterator();
        while (it.hasNext()) {
            ExternalizedFlowDefinition definition = (ExternalizedFlowDefinition)it.next();
            FlowBuilder builder = this.createFlowBuilder(definition.getLocation(), flowServiceLocator);
            this.registerFlow(definition, registry, builder);
        }
    }

    protected boolean isFlowDefinition(Resource resource) {
        return true;
    }

    protected ExternalizedFlowDefinition createFlowDefinition(Resource location) {
        return new ExternalizedFlowDefinition(location);
    }

    protected abstract FlowBuilder createFlowBuilder(Resource var1, FlowServiceLocator var2);

    public String toString() {
        return new ToStringCreator((Object)this).append("flowLocations", (Object)this.flowLocations).append("flowDefinitions", (Object)this.flowDefinitions).toString();
    }
}

