/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.registry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.webflow.UnmodifiableAttributeMap;
import org.springframework.webflow.builder.FlowAssembler;
import org.springframework.webflow.builder.FlowBuilder;
import org.springframework.webflow.builder.FlowServiceLocator;
import org.springframework.webflow.builder.XmlFlowBuilder;
import org.springframework.webflow.registry.ExternalizedFlowDefinition;
import org.springframework.webflow.registry.FlowHolder;
import org.springframework.webflow.registry.FlowRegistrar;
import org.springframework.webflow.registry.FlowRegistry;
import org.springframework.webflow.registry.RefreshableFlowHolder;

public abstract class FlowRegistrarSupport
implements FlowRegistrar {
    protected final Log logger = LogFactory.getLog(this.getClass());

    protected void registerFlow(String flowId, FlowRegistry registry, FlowBuilder flowBuilder) {
        this.registerFlow(flowId, registry, flowBuilder, null);
    }

    protected void registerFlow(String flowId, FlowRegistry registry, FlowBuilder flowBuilder, UnmodifiableAttributeMap attributes) {
        registry.registerFlow(this.createFlowHolder(new FlowAssembler(flowId, attributes, flowBuilder)));
    }

    protected void registerFlow(ExternalizedFlowDefinition flowDefinition, FlowRegistry registry, FlowBuilder flowBuilder) {
        this.registerFlow(flowDefinition.getId(), registry, flowBuilder, flowDefinition.getAttributes());
    }

    protected void registerXmlFlow(Resource location, FlowRegistry registry, FlowServiceLocator flowServiceLocator) {
        this.registerXmlFlow(new ExternalizedFlowDefinition(location), registry, flowServiceLocator);
    }

    protected void registerXmlFlow(ExternalizedFlowDefinition flowDefinition, FlowRegistry registry, FlowServiceLocator flowServiceLocator) {
        this.registerFlow(flowDefinition, registry, (FlowBuilder)new XmlFlowBuilder(flowDefinition.getLocation(), flowServiceLocator));
    }

    protected FlowHolder createFlowHolder(FlowAssembler assembler) {
        return new RefreshableFlowHolder(assembler);
    }

    public abstract void registerFlows(FlowRegistry var1, FlowServiceLocator var2);
}

