/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.registry;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.Flow;
import org.springframework.webflow.builder.FlowBuilderException;
import org.springframework.webflow.execution.FlowConstructionException;
import org.springframework.webflow.execution.FlowLocatorException;
import org.springframework.webflow.execution.NoSuchFlowDefinitionException;
import org.springframework.webflow.registry.FlowHolder;
import org.springframework.webflow.registry.FlowRegistry;

public class FlowRegistryImpl
implements FlowRegistry {
    private Map flowDefinitions = new TreeMap();
    private FlowRegistry parent;

    public void setParent(FlowRegistry parent) {
        this.parent = parent;
    }

    public String[] getFlowIds() {
        return this.flowDefinitions.keySet().toArray(new String[this.flowDefinitions.size()]);
    }

    public int getFlowCount() {
        return this.flowDefinitions.size();
    }

    public boolean containsFlow(String id) {
        Assert.hasText((String)id, (String)"The flow id is required");
        return this.flowDefinitions.get(id) != null;
    }

    public Flow[] getFlows() {
        Flow[] flows = new Flow[this.flowDefinitions.size()];
        Iterator it = this.flowDefinitions.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            FlowHolder holder = (FlowHolder)it.next();
            flows[i] = holder.getFlow();
            ++i;
        }
        return flows;
    }

    public void registerFlow(FlowHolder flowHolder) {
        Assert.notNull((Object)flowHolder, (String)"The flow definition holder to register is required");
        this.index(flowHolder);
    }

    public void removeFlowDefinition(String id) {
        Assert.hasText((String)id, (String)"The flow id is required");
        this.flowDefinitions.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            LinkedList<Indexed> needsReindexing = new LinkedList<Indexed>();
            Iterator it = this.flowDefinitions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                FlowHolder holder = (FlowHolder)entry.getValue();
                holder.refresh();
                if (holder.getId().equals(key)) continue;
                needsReindexing.add(new Indexed(key, holder));
            }
            it = needsReindexing.iterator();
            while (it.hasNext()) {
                Indexed indexed = (Indexed)((Object)it.next());
                this.reindex(indexed.holder, indexed.key);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String flowId) throws NoSuchFlowDefinitionException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            FlowHolder holder = this.getFlowDefinitionHolder(flowId);
            holder.refresh();
            if (!holder.getId().equals(flowId)) {
                this.reindex(holder, flowId);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    private void reindex(FlowHolder holder, String oldId) {
        this.flowDefinitions.remove(oldId);
        this.index(holder);
    }

    private void index(FlowHolder holder) {
        Assert.hasText((String)holder.getId(), (String)"The flow holder to index must return a non-blank flow id");
        this.flowDefinitions.put(holder.getId(), holder);
    }

    private FlowHolder getFlowDefinitionHolder(String id) {
        FlowHolder flowHolder = (FlowHolder)this.flowDefinitions.get(id);
        if (flowHolder == null) {
            throw new NoSuchFlowDefinitionException(id, this.getFlowIds());
        }
        return flowHolder;
    }

    public Flow getFlow(String id) throws FlowLocatorException {
        Assert.hasText((String)id, (String)"Unable to load a flow definition: no flow id was provided.  Please provide a valid flow identifier.");
        try {
            return this.getFlowDefinitionHolder(id).getFlow();
        }
        catch (NoSuchFlowDefinitionException e) {
            if (this.parent != null) {
                return this.parent.getFlow(id);
            }
            throw e;
        }
        catch (FlowBuilderException e) {
            throw new FlowConstructionException(id, (Throwable)((Object)e));
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("flowDefinitions", (Object)this.flowDefinitions).append("parent", (Object)this.parent).toString();
    }

    private static class Indexed {
        private String key;
        private FlowHolder holder;

        public Indexed(String key, FlowHolder holder) {
            this.key = key;
            this.holder = holder;
        }
    }
}

