/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.registry;

import org.springframework.core.io.Resource;
import org.springframework.webflow.builder.FlowBuilder;
import org.springframework.webflow.builder.FlowServiceLocator;
import org.springframework.webflow.builder.XmlFlowBuilder;
import org.springframework.webflow.registry.ExternalizedFlowRegistrar;
import org.xml.sax.EntityResolver;

public class XmlFlowRegistrar
extends ExternalizedFlowRegistrar {
    private static final String XML_SUFFIX = ".xml";
    private boolean builderValidating = true;
    private EntityResolver entityResolver;

    public void setBuilderValidating(boolean builderValidating) {
        this.builderValidating = builderValidating;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    protected boolean isFlowDefinition(Resource resource) {
        return resource.getFilename().endsWith(XML_SUFFIX);
    }

    protected FlowBuilder createFlowBuilder(Resource location, FlowServiceLocator flowServiceLocator) {
        XmlFlowBuilder builder = new XmlFlowBuilder(location, flowServiceLocator);
        builder.setValidating(this.builderValidating);
        if (this.entityResolver != null) {
            builder.setEntityResolver(this.entityResolver);
        }
        return builder;
    }
}

