/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import java.io.Serializable;
import java.util.Collections;
import org.springframework.binding.expression.Expression;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.ViewSelector;
import org.springframework.webflow.support.ApplicationView;
import org.springframework.webflow.support.FlowExecutionRedirect;

public class ApplicationViewSelector
implements ViewSelector,
Serializable {
    private Expression viewName;
    private boolean redirect;

    public ApplicationViewSelector(Expression viewName) {
        this(viewName, false);
    }

    public ApplicationViewSelector(Expression viewName, boolean redirect) {
        Assert.notNull((Object)viewName, (String)"The view name expression is required");
        this.viewName = viewName;
        this.redirect = redirect;
    }

    public Expression getViewName() {
        return this.viewName;
    }

    public ViewSelection makeSelection(RequestContext context) {
        if (this.redirect) {
            return FlowExecutionRedirect.INSTANCE;
        }
        return this.makeRefreshSelection(context);
    }

    public ViewSelection makeRefreshSelection(RequestContext context) {
        String viewName = this.resolveViewName(context);
        if (!StringUtils.hasText((String)viewName)) {
            return ViewSelection.NULL_VIEW;
        }
        return this.createApplicationView(viewName, context);
    }

    protected String resolveViewName(RequestContext context) {
        return (String)this.getViewName().evaluateAgainst((Object)context, Collections.EMPTY_MAP);
    }

    protected ApplicationView createApplicationView(String viewName, RequestContext context) {
        return new ApplicationView(viewName, context.getModel().getMap());
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("viewName", (Object)this.viewName).append("redirect", this.redirect).toString();
    }
}

