/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.webflow.FlowVariable;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.ScopeType;

public class BeanFactoryFlowVariable
extends FlowVariable {
    private String beanName;
    private BeanFactory beanFactory;

    public BeanFactoryFlowVariable(String variableName, String beanName, BeanFactory beanFactory) {
        this(variableName, beanName, beanFactory, null);
    }

    public BeanFactoryFlowVariable(String variableName, String beanName, BeanFactory beanFactory, ScopeType scope) {
        super(variableName, scope);
        this.beanName = StringUtils.hasText((String)beanName) ? beanName : variableName;
        Assert.notNull((Object)beanFactory, (String)"The variable bean factory is required");
        Assert.isTrue((!beanFactory.isSingleton(this.beanName) ? 1 : 0) != 0, (String)("The variable bean with name '" + this.beanName + "' must be a prototype (singleton=false)"));
        this.beanFactory = beanFactory;
    }

    protected Object createVariableValue(RequestContext context) {
        return this.beanFactory.getBean(this.beanName);
    }
}

