/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import org.springframework.binding.expression.ExpressionParser;
import org.springframework.webflow.support.WebFlowOgnlExpressionParser;

public class DefaultExpressionParserFactory {
    private static ExpressionParser INSTANCE;

    public synchronized ExpressionParser getExpressionParser() {
        if (INSTANCE == null) {
            INSTANCE = this.createDefaultExpressionParser();
        }
        return INSTANCE;
    }

    protected ExpressionParser createDefaultExpressionParser() {
        try {
            Class.forName("ognl.Ognl");
            return new WebFlowOgnlExpressionParser();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load the default expression parser: OGNL could not be found in the classpath.  Please add OGNL 2.x to your classpath or set the default ExpressionParser instance to something that is in the classpath.  Details: " + e.getMessage());
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalStateException("Unable to construct the default expression parser: ognl.Ognl could not be instantiated.  Please add OGNL 2.x to your classpath or set the default ExpressionParser instance to something that is in the classpath.  Details: " + e);
        }
    }
}

