/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.PropertyExpression;
import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.binding.mapping.DefaultAttributeMapper;
import org.springframework.binding.mapping.Mapping;
import org.springframework.binding.mapping.MappingBuilder;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.support.AbstractFlowAttributeMapper;
import org.springframework.webflow.support.DefaultExpressionParserFactory;
import org.springframework.webflow.support.FlowScopeExpression;

public class DefaultFlowAttributeMapper
extends AbstractFlowAttributeMapper
implements Serializable {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ExpressionParser expressionParser = new DefaultExpressionParserFactory().getExpressionParser();
    private DefaultAttributeMapper inputMapper = new DefaultAttributeMapper();
    private DefaultAttributeMapper outputMapper = new DefaultAttributeMapper();

    public DefaultFlowAttributeMapper addInputMapping(Mapping inputMapping) {
        this.inputMapper.addMapping(inputMapping);
        return this;
    }

    public void addInputMappings(Mapping[] inputMappings) {
        this.inputMapper.addMappings(inputMappings);
    }

    public DefaultFlowAttributeMapper addInputAttribute(String inputAttributeName) {
        PropertyExpression expr = this.expressionParser.parsePropertyExpression(inputAttributeName);
        this.inputMapper.addMapping(new Mapping((Expression)new FlowScopeExpression((Expression)expr), expr, null));
        return this;
    }

    public void addInputAttributes(String[] inputAttributeNames) {
        if (inputAttributeNames == null) {
            return;
        }
        for (int i = 0; i < inputAttributeNames.length; ++i) {
            this.addInputAttribute(inputAttributeNames[i]);
        }
    }

    public DefaultFlowAttributeMapper addOutputMapping(Mapping outputMapping) {
        this.outputMapper.addMapping(outputMapping);
        return this;
    }

    public void addOutputMappings(Mapping[] outputMappings) {
        this.outputMapper.addMappings(outputMappings);
    }

    public DefaultFlowAttributeMapper addOutputAttribute(String outputAttributeName) {
        this.outputMapper.addMapping(this.mapping().source(outputAttributeName).value());
        return this;
    }

    public void addOutputAttributes(String[] outputAttributeNames) {
        if (outputAttributeNames == null) {
            return;
        }
        for (int i = 0; i < outputAttributeNames.length; ++i) {
            this.addOutputAttribute(outputAttributeNames[i]);
        }
    }

    public Mapping[] getInputMappings() {
        return this.inputMapper.getMappings();
    }

    public Mapping[] getOutputMappings() {
        return this.outputMapper.getMappings();
    }

    protected MappingBuilder mapping() {
        return new MappingBuilder(this.expressionParser);
    }

    protected AttributeMapper getInputMapper() {
        return this.inputMapper;
    }

    protected AttributeMapper getOutputMapper() {
        return this.outputMapper;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("inputMapper", (Object)this.inputMapper).append("outputMapper", (Object)this.outputMapper).toString();
    }
}

