/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.support.StaticExpression;
import org.springframework.util.Assert;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.State;
import org.springframework.webflow.TargetStateResolver;
import org.springframework.webflow.Transition;
import org.springframework.webflow.TransitionableState;

public class DefaultTargetStateResolver
implements TargetStateResolver {
    private Expression targetStateId;

    public DefaultTargetStateResolver(String targetStateId) {
        this((Expression)new StaticExpression((Object)targetStateId));
    }

    public DefaultTargetStateResolver(Expression targetStateIdExpression) {
        Assert.notNull((Object)targetStateIdExpression, (String)"The target state id expression is required");
        this.targetStateId = targetStateIdExpression;
    }

    public Expression getTargetStateId() {
        return this.targetStateId;
    }

    public State resolveTargetState(Transition transition, TransitionableState sourceState, RequestContext context) {
        String stateId = String.valueOf(this.targetStateId.evaluateAgainst((Object)context, null));
        return sourceState.getFlow().getRequiredState(stateId);
    }

    public String toString() {
        return "[targetStateId = '" + this.targetStateId + "']";
    }
}

