/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import java.io.Serializable;
import org.springframework.util.Assert;
import org.springframework.webflow.Event;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.TransitionCriteria;

public class EventIdTransitionCriteria
implements TransitionCriteria,
Serializable {
    private String eventId;

    public EventIdTransitionCriteria(String eventId) {
        Assert.hasText((String)eventId, (String)"The event id is required");
        this.eventId = eventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public boolean test(RequestContext context) {
        Event lastEvent = context.getLastEvent();
        if (lastEvent == null) {
            return false;
        }
        return this.eventId.equalsIgnoreCase(lastEvent.getId());
    }

    public String toString() {
        return "[eventId = '" + this.eventId + "']";
    }
}

