/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import java.util.Collections;
import java.util.HashMap;
import org.springframework.binding.expression.Expression;
import org.springframework.util.StringUtils;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.ViewSelector;
import org.springframework.webflow.support.FlowRedirect;

public class FlowRedirectSelector
implements ViewSelector {
    private Expression expression;

    public FlowRedirectSelector(Expression expression) {
        this.expression = expression;
    }

    public ViewSelection makeRefreshSelection(RequestContext context) {
        return this.makeSelection(context);
    }

    public ViewSelection makeSelection(RequestContext context) {
        String flowId;
        String flowRedirect = (String)this.expression.evaluateAgainst((Object)context, Collections.EMPTY_MAP);
        if (flowRedirect == null) {
            throw new IllegalStateException("Flow redirect expression evaluated to [null], the expression was " + this.expression);
        }
        int index = flowRedirect.indexOf(63);
        HashMap<String, String> input = null;
        if (index != -1) {
            flowId = flowRedirect.substring(0, index);
            String[] parameters = StringUtils.delimitedListToStringArray((String)flowRedirect.substring(index + 1), (String)"&");
            input = new HashMap<String, String>(parameters.length, 1.0f);
            for (int i = 0; i < parameters.length; ++i) {
                String nameAndValue = parameters[i];
                index = nameAndValue.indexOf(61);
                if (index != -1) {
                    input.put(nameAndValue.substring(0, index), nameAndValue.substring(index + 1));
                    continue;
                }
                input.put(nameAndValue, "");
            }
        } else {
            flowId = flowRedirect;
        }
        if (!StringUtils.hasText((String)flowId)) {
            flowId = context.getFlowExecutionContext().getFlow().getId();
        }
        return new FlowRedirect(flowId, input);
    }
}

