/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.JdkVersion;
import org.springframework.core.NestedRuntimeException;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.FlowExecutionException;
import org.springframework.webflow.FlowExecutionExceptionHandler;
import org.springframework.webflow.RequestControlContext;
import org.springframework.webflow.State;
import org.springframework.webflow.TargetStateResolver;
import org.springframework.webflow.Transition;
import org.springframework.webflow.TransitionableState;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.support.DefaultTargetStateResolver;

public class TransitionExecutingStateExceptionHandler
implements FlowExecutionExceptionHandler {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$support$TransitionExecutingStateExceptionHandler == null ? (class$org$springframework$webflow$support$TransitionExecutingStateExceptionHandler = TransitionExecutingStateExceptionHandler.class$("org.springframework.webflow.support.TransitionExecutingStateExceptionHandler")) : class$org$springframework$webflow$support$TransitionExecutingStateExceptionHandler));
    public static final String STATE_EXCEPTION_ATTRIBUTE = "stateException";
    public static final String ROOT_CAUSE_EXCEPTION_ATTRIBUTE = "rootCauseException";
    private Map exceptionTargetStateResolverMappings = new HashMap();
    static /* synthetic */ Class class$org$springframework$webflow$support$TransitionExecutingStateExceptionHandler;
    static /* synthetic */ Class class$java$lang$Object;

    public TransitionExecutingStateExceptionHandler add(Class exceptionClass, String targetStateId) {
        return this.add(exceptionClass, new DefaultTargetStateResolver(targetStateId));
    }

    public TransitionExecutingStateExceptionHandler add(Class exceptionClass, TargetStateResolver targetStateResolver) {
        Assert.notNull((Object)exceptionClass, (String)"The exception class is required");
        Assert.notNull((Object)targetStateResolver, (String)"The target state resolver is required");
        this.exceptionTargetStateResolverMappings.put(exceptionClass, targetStateResolver);
        return this;
    }

    public boolean handles(FlowExecutionException e) {
        return this.getTargetStateResolver(e) != null;
    }

    public ViewSelection handle(FlowExecutionException e, RequestControlContext context) {
        State sourceState;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Handling state exception " + (Object)((Object)e)));
        }
        if (!((sourceState = context.getCurrentState()) instanceof TransitionableState)) {
            throw new IllegalStateException("The source state '" + sourceState.getId() + "' to transition from must be transitionable!");
        }
        context.getRequestScope().put(STATE_EXCEPTION_ATTRIBUTE, (Object)e);
        Throwable rootCause = this.findRootCause((Throwable)((Object)e));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Exposing state exception root cause " + rootCause + " under attribute '" + ROOT_CAUSE_EXCEPTION_ATTRIBUTE + "'"));
        }
        context.getRequestScope().put(ROOT_CAUSE_EXCEPTION_ATTRIBUTE, rootCause);
        return new Transition(this.getTargetStateResolver(e)).execute((TransitionableState)sourceState, context);
    }

    protected TargetStateResolver getTargetStateResolver(FlowExecutionException e) {
        if (JdkVersion.getMajorJavaVersion() == 0) {
            return this.getTargetStateResolver13(e);
        }
        return this.getTargetStateResolver14((Throwable)((Object)e));
    }

    private TargetStateResolver getTargetStateResolver13(NestedRuntimeException e) {
        if (this.isRootCause13(e)) {
            return this.findTargetStateResolver(e.getClass());
        }
        TargetStateResolver resolver = (TargetStateResolver)this.exceptionTargetStateResolverMappings.get(e.getClass());
        if (resolver != null) {
            return resolver;
        }
        if (e.getCause() instanceof NestedRuntimeException) {
            return this.getTargetStateResolver13((NestedRuntimeException)e.getCause());
        }
        return null;
    }

    private TargetStateResolver getTargetStateResolver14(Throwable t) {
        if (this.isRootCause14(t)) {
            return this.findTargetStateResolver(t.getClass());
        }
        TargetStateResolver resolver = (TargetStateResolver)this.exceptionTargetStateResolverMappings.get(t.getClass());
        if (resolver != null) {
            return resolver;
        }
        return this.getTargetStateResolver14(t.getCause());
    }

    private boolean isRootCause13(NestedRuntimeException t) {
        return t.getCause() == null;
    }

    private boolean isRootCause14(Throwable t) {
        return t.getCause() == null;
    }

    private TargetStateResolver findTargetStateResolver(Class argumentType) {
        while (argumentType != null && argumentType.getClass() != (class$java$lang$Object == null ? TransitionExecutingStateExceptionHandler.class$("java.lang.Object") : class$java$lang$Object)) {
            if (this.exceptionTargetStateResolverMappings.containsKey(argumentType)) {
                return (TargetStateResolver)this.exceptionTargetStateResolverMappings.get(argumentType);
            }
            argumentType = argumentType.getSuperclass();
        }
        return null;
    }

    protected Throwable findRootCause(Throwable e) {
        return new RootCauseResolver().findRootCause(e);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("exceptionTargetStateResolverMappings", (Object)this.exceptionTargetStateResolverMappings).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class RootCauseResolver {
        private RootCauseResolver() {
        }

        public Throwable findRootCause(Throwable e) {
            if (JdkVersion.getMajorJavaVersion() == 0) {
                return this.findRootCause13(e);
            }
            return this.findRootCause14(e);
        }

        private Throwable findRootCause13(Throwable e) {
            if (e instanceof NestedRuntimeException) {
                NestedRuntimeException nre = (NestedRuntimeException)e;
                Throwable cause = e.getCause();
                if (cause == null) {
                    return nre;
                }
                return this.findRootCause13(cause);
            }
            return e;
        }

        private Throwable findRootCause14(Throwable e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                return e;
            }
            return this.findRootCause14(cause);
        }
    }
}

