/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.core.io.Resource;
import org.springframework.webflow.Flow;
import org.springframework.webflow.builder.FlowArtifactLookupException;
import org.springframework.webflow.builder.FlowAssembler;
import org.springframework.webflow.builder.FlowBuilder;
import org.springframework.webflow.builder.FlowServiceLocator;
import org.springframework.webflow.registry.ExternalizedFlowDefinition;
import org.springframework.webflow.test.AbstractFlowExecutionTests;
import org.springframework.webflow.test.MockFlowServiceLocator;

public abstract class AbstractExternalizedFlowExecutionTests
extends AbstractFlowExecutionTests {
    private static Flow cachedFlowDefinition;
    private boolean cacheFlowDefinition;

    public boolean isCacheFlowDefinition() {
        return this.cacheFlowDefinition;
    }

    public void setCacheFlowDefinition(boolean cacheFlowDefinition) {
        this.cacheFlowDefinition = cacheFlowDefinition;
    }

    protected Flow getFlow() throws FlowArtifactLookupException {
        if (this.isCacheFlowDefinition() && cachedFlowDefinition != null) {
            return cachedFlowDefinition;
        }
        FlowServiceLocator flowServiceLocator = this.createFlowServiceLocator();
        ExternalizedFlowDefinition flowDefinition = this.getFlowDefinition();
        FlowBuilder builder = this.createFlowBuilder(flowDefinition.getLocation(), flowServiceLocator);
        new FlowAssembler(flowDefinition.getId(), flowDefinition.getAttributes(), builder).assembleFlow();
        Flow flow = builder.getFlow();
        if (this.isCacheFlowDefinition()) {
            cachedFlowDefinition = flow;
        }
        return flow;
    }

    protected FlowServiceLocator createFlowServiceLocator() {
        return new MockFlowServiceLocator();
    }

    protected abstract FlowBuilder createFlowBuilder(Resource var1, FlowServiceLocator var2);

    protected abstract ExternalizedFlowDefinition getFlowDefinition();
}

