/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowExecutionContext;
import org.springframework.webflow.FlowSession;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.test.MockFlowSession;

public class MockFlowExecutionContext
implements FlowExecutionContext {
    private Flow flow;
    private FlowSession activeSession;
    private AttributeMap conversationScope = new AttributeMap();
    private ViewSelection currentViewSelection;

    public MockFlowExecutionContext() {
        this.activeSession = new MockFlowSession();
        this.flow = this.activeSession.getFlow();
    }

    public MockFlowExecutionContext(Flow rootFlow) {
        this.flow = rootFlow;
        this.activeSession = new MockFlowSession(rootFlow);
    }

    public String getCaption() {
        return "Mock flow execution context";
    }

    public Flow getFlow() {
        return this.flow;
    }

    public boolean isActive() {
        return this.activeSession != null;
    }

    public FlowSession getActiveSession() throws IllegalStateException {
        if (this.activeSession == null) {
            throw new IllegalStateException("No flow session is active");
        }
        return this.activeSession;
    }

    public AttributeMap getConversationScope() {
        return this.conversationScope;
    }

    public void setFlow(Flow rootFlow) {
        this.flow = rootFlow;
    }

    public void setActiveSession(FlowSession activeSession) {
        this.activeSession = activeSession;
    }

    public void setConversationScope(AttributeMap scope) {
        this.conversationScope = scope;
    }

    public MockFlowSession getMockActiveSession() {
        return (MockFlowSession)this.activeSession;
    }

    public ViewSelection getCurrentViewSelection() {
        return this.currentViewSelection;
    }

    public void setCurrentViewSelection(ViewSelection currentViewSelection) {
        this.currentViewSelection = currentViewSelection;
    }
}

