/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowSession;
import org.springframework.webflow.FlowSessionStatus;
import org.springframework.webflow.State;
import org.springframework.webflow.ViewState;

public class MockFlowSession
implements FlowSession {
    private Flow flow;
    private State state;
    private FlowSessionStatus status = FlowSessionStatus.CREATED;
    private AttributeMap scope = new AttributeMap();
    private FlowSession parent;

    public MockFlowSession() {
        this.setFlow(new Flow("mockFlow"));
        ViewState state = new ViewState(this.flow, "mockState");
        this.setStatus(FlowSessionStatus.ACTIVE);
        this.setState(state);
    }

    public MockFlowSession(Flow flow) {
        this.setFlow(flow);
    }

    public MockFlowSession(Flow flow, AttributeMap input) {
        this.setFlow(flow);
        this.scope.putAll(input);
    }

    public Flow getFlow() {
        return this.flow;
    }

    public State getState() {
        return this.state;
    }

    public AttributeMap getScope() {
        return this.scope;
    }

    public FlowSessionStatus getStatus() {
        return this.status;
    }

    public FlowSession getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setStatus(FlowSessionStatus status) {
        this.status = status;
    }

    public void setScope(AttributeMap scope) {
        this.scope = scope;
    }

    public void setParent(FlowSession parent) {
        this.parent = parent;
    }
}

