/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Event;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowSession;
import org.springframework.webflow.FlowSessionStatus;
import org.springframework.webflow.RequestControlContext;
import org.springframework.webflow.State;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.test.MockFlowSession;
import org.springframework.webflow.test.MockRequestContext;

public class MockRequestControlContext
extends MockRequestContext
implements RequestControlContext {
    public MockRequestControlContext(Flow rootFlow) {
        super(rootFlow);
    }

    public ViewSelection start(Flow flow, AttributeMap input) throws IllegalStateException {
        this.getMockFlowExecutionContext().setActiveSession(new MockFlowSession(flow, input));
        this.getMockFlowExecutionContext().getMockActiveSession().setStatus(FlowSessionStatus.STARTING);
        ViewSelection selectedView = flow.start(this, input);
        return selectedView;
    }

    public ViewSelection signalEvent(Event event) {
        this.setLastEvent(event);
        ViewSelection selectedView = this.getActiveFlow().onEvent(this);
        return selectedView;
    }

    public FlowSession endActiveFlowSession(AttributeMap output) throws IllegalStateException {
        MockFlowSession endingSession = this.getMockFlowExecutionContext().getMockActiveSession();
        endingSession.getFlow().end(this, output);
        endingSession.setStatus(FlowSessionStatus.ENDED);
        this.getMockFlowExecutionContext().setActiveSession(null);
        return endingSession;
    }

    public void setCurrentState(State state) {
        this.getMockFlowExecutionContext().getMockActiveSession().setState(state);
        State previousState = this.getCurrentState();
        if (previousState == null) {
            this.getMockFlowExecutionContext().getMockActiveSession().setStatus(FlowSessionStatus.ACTIVE);
        }
    }
}

