/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.binding.method.ClassMethodKey;
import org.springframework.binding.method.InvalidMethodSignatureException;
import org.springframework.core.NestedRuntimeException;
import org.springframework.util.Assert;
import org.springframework.util.CachingMapDecorator;
import org.springframework.util.ClassUtils;

public class DispatchMethodInvoker {
    private Object target;
    private Class[] parameterTypes;
    private Map methodCache = new CachingMapDecorator(){

        public Object create(Object key) {
            String methodName = (String)key;
            try {
                return new ClassMethodKey(DispatchMethodInvoker.this.target.getClass(), methodName, DispatchMethodInvoker.this.parameterTypes).getMethod();
            }
            catch (InvalidMethodSignatureException e) {
                throw new MethodLookupException("Unable to resolve dispatch method with name '" + methodName + "' and signature '" + DispatchMethodInvoker.this.getSignatureString(methodName) + "'; make sure the method name is correct and such a method is defined on targetClass " + DispatchMethodInvoker.this.target.getClass().getName(), e);
            }
        }
    };

    public DispatchMethodInvoker(Object target, Class[] parameterTypes) {
        Assert.notNull((Object)target, (String)"The target of a dispatch method invocation is required");
        this.target = target;
        this.parameterTypes = parameterTypes;
    }

    public Object getTarget() {
        return this.target;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Object invoke(String methodName, Object[] arguments) throws MethodLookupException, Exception {
        try {
            Method dispatchMethod = this.getDispatchMethod(methodName);
            return dispatchMethod.invoke(this.target, arguments);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw (Error)e.getTargetException();
        }
    }

    private Method getDispatchMethod(String methodName) throws MethodLookupException {
        return (Method)this.methodCache.get(methodName);
    }

    private String getSignatureString(String methodName) {
        return methodName + "(" + this.getParameterTypesString() + ");";
    }

    private String getParameterTypesString() {
        StringBuffer parameterTypesString = new StringBuffer();
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            parameterTypesString.append(ClassUtils.getShortName((Class)this.parameterTypes[i]));
            if (i >= this.parameterTypes.length - 1) continue;
            parameterTypesString.append(',');
        }
        return parameterTypesString.toString();
    }

    public static class MethodLookupException
    extends NestedRuntimeException {
        public MethodLookupException(String msg, Throwable ex) {
            super(msg, ex);
        }
    }
}

