/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.URI;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.server.DefaultServerResponseBuilder;
import org.springframework.web.reactive.function.server.EntityResponse;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

class DefaultEntityResponseBuilder<T>
implements EntityResponse.Builder<T> {
    private final T entity;
    private final BodyInserter<T, ? super ServerHttpResponse> inserter;
    private HttpStatus status = HttpStatus.OK;
    private final HttpHeaders headers = new HttpHeaders();
    private final Map<String, Object> hints = new HashMap<String, Object>();

    public DefaultEntityResponseBuilder(T entity, BodyInserter<T, ? super ServerHttpResponse> inserter) {
        this.entity = entity;
        this.inserter = inserter;
    }

    @Override
    public EntityResponse.Builder<T> status(HttpStatus status) {
        Assert.notNull((Object)status, (String)"'status' must not be null");
        this.status = status;
        return this;
    }

    @Override
    public EntityResponse.Builder<T> header(String headerName, String ... headerValues) {
        for (String headerValue : headerValues) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    @Override
    public EntityResponse.Builder<T> headers(HttpHeaders headers2) {
        this.headers.putAll((Map)headers2);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> allow(HttpMethod ... allowedMethods) {
        this.headers.setAllow(new LinkedHashSet<HttpMethod>(Arrays.asList(allowedMethods)));
        return this;
    }

    @Override
    public EntityResponse.Builder<T> allow(Set<HttpMethod> allowedMethods) {
        this.headers.setAllow(allowedMethods);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> contentLength(long contentLength) {
        this.headers.setContentLength(contentLength);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> contentType(MediaType contentType2) {
        this.headers.setContentType(contentType2);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> eTag(String etag) {
        if (!etag.startsWith("\"") && !etag.startsWith("W/\"")) {
            etag = "\"" + etag;
        }
        if (!etag.endsWith("\"")) {
            etag = etag + "\"";
        }
        this.headers.setETag(etag);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> hint(String key, Object value) {
        this.hints.put(key, value);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> lastModified(ZonedDateTime lastModified) {
        ZonedDateTime gmt = lastModified.withZoneSameInstant(ZoneId.of("GMT"));
        String headerValue = DateTimeFormatter.RFC_1123_DATE_TIME.format(gmt);
        this.headers.set("Last-Modified", headerValue);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> location(URI location) {
        this.headers.setLocation(location);
        return this;
    }

    @Override
    public EntityResponse.Builder<T> cacheControl(CacheControl cacheControl) {
        String ccValue = cacheControl.getHeaderValue();
        if (ccValue != null) {
            this.headers.setCacheControl(cacheControl.getHeaderValue());
        }
        return this;
    }

    @Override
    public EntityResponse.Builder<T> varyBy(String ... requestHeaders) {
        this.headers.setVary(Arrays.asList(requestHeaders));
        return this;
    }

    @Override
    public Mono<EntityResponse<T>> build() {
        return Mono.just(new DefaultEntityResponse<T>(this.status, this.headers, this.entity, this.inserter, this.hints));
    }

    private static final class DefaultEntityResponse<T>
    extends DefaultServerResponseBuilder.AbstractServerResponse
    implements EntityResponse<T> {
        private final T entity;
        private final BodyInserter<T, ? super ServerHttpResponse> inserter;
        private final Map<String, Object> hints;

        public DefaultEntityResponse(HttpStatus statusCode, HttpHeaders headers2, T entity, BodyInserter<T, ? super ServerHttpResponse> inserter, Map<String, Object> hints) {
            super(statusCode, headers2);
            this.entity = entity;
            this.inserter = inserter;
            this.hints = hints;
        }

        @Override
        public T entity() {
            return this.entity;
        }

        @Override
        public BodyInserter<T, ? super ServerHttpResponse> inserter() {
            return this.inserter;
        }

        @Override
        public Mono<Void> writeTo(final ServerWebExchange exchange, final ServerResponse.Context context) {
            ServerHttpResponse response = exchange.getResponse();
            this.writeStatusAndHeaders(response);
            return this.inserter().insert(response, new BodyInserter.Context(){

                @Override
                public List<HttpMessageWriter<?>> messageWriters() {
                    return context.messageWriters();
                }

                @Override
                public Optional<ServerHttpRequest> serverRequest() {
                    return Optional.of(exchange.getRequest());
                }

                @Override
                public Map<String, Object> hints() {
                    return hints;
                }
            });
        }
    }
}

