/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.util.DigestUtils;
import org.springframework.web.reactive.resource.AbstractFileNameVersionStrategy;
import reactor.core.publisher.Mono;

public class ContentVersionStrategy
extends AbstractFileNameVersionStrategy {
    private static final DataBufferFactory dataBufferFactory = new DefaultDataBufferFactory();

    @Override
    public Mono<String> getResourceVersion(Resource resource) {
        return DataBufferUtils.read((Resource)resource, (DataBufferFactory)dataBufferFactory, (int)4096).reduce((rec$, xva$0) -> ((DataBuffer)rec$).write(new DataBuffer[]{xva$0})).map(buffer -> {
            byte[] result = new byte[buffer.readableByteCount()];
            buffer.read(result);
            DataBufferUtils.release((DataBuffer)buffer);
            return DigestUtils.md5DigestAsHex((byte[])result);
        });
    }
}

