/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.HandlerResultHandlerSupport;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractMessageWriterResultHandler
extends HandlerResultHandlerSupport {
    private final List<HttpMessageWriter<?>> messageWriters;

    protected AbstractMessageWriterResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver) {
        this(messageWriters, contentTypeResolver, ReactiveAdapterRegistry.getSharedInstance());
    }

    protected AbstractMessageWriterResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver, ReactiveAdapterRegistry adapterRegistry) {
        super(contentTypeResolver, adapterRegistry);
        Assert.notEmpty(messageWriters, (String)"At least one message writer is required");
        this.messageWriters = messageWriters;
    }

    public List<HttpMessageWriter<?>> getMessageWriters() {
        return this.messageWriters;
    }

    protected Mono<Void> writeBody(@Nullable Object body2, MethodParameter bodyParameter, ServerWebExchange exchange) {
        return this.writeBody(body2, bodyParameter, null, exchange);
    }

    protected Mono<Void> writeBody(@Nullable Object body2, MethodParameter bodyParameter, @Nullable MethodParameter actualParam, ServerWebExchange exchange) {
        ResolvableType elementType;
        Mono publisher;
        ResolvableType bodyType = ResolvableType.forMethodParameter((MethodParameter)bodyParameter);
        ResolvableType actualType = actualParam != null ? ResolvableType.forMethodParameter((MethodParameter)actualParam) : bodyType;
        Class bodyClass = bodyType.resolve();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(bodyClass, body2);
        if (adapter != null) {
            publisher = adapter.toPublisher(body2);
            ResolvableType genericType = bodyType.getGeneric(new int[0]);
            elementType = this.getElementType(adapter, genericType);
        } else {
            publisher = Mono.justOrEmpty((Object)body2);
            ResolvableType resolvableType = elementType = (bodyClass == null || bodyClass == Object.class) && body2 != null ? ResolvableType.forInstance((Object)body2) : bodyType;
        }
        if (elementType.getRawClass() == Void.TYPE || elementType.getRawClass() == Void.class) {
            return Mono.from((Publisher)publisher);
        }
        MediaType bestMediaType = this.selectMediaType(exchange, () -> this.getMediaTypesFor(elementType));
        if (bestMediaType != null) {
            for (HttpMessageWriter<?> writer : this.getMessageWriters()) {
                if (!writer.canWrite(elementType, bestMediaType)) continue;
                return writer.write((Publisher)publisher, actualType, elementType, bestMediaType, exchange.getRequest(), exchange.getResponse(), Collections.emptyMap());
            }
        }
        List<MediaType> mediaTypes = this.getMediaTypesFor(elementType);
        if (bestMediaType == null && mediaTypes.isEmpty()) {
            return Mono.error((Throwable)new IllegalStateException("No HttpMessageWriter for " + elementType));
        }
        return Mono.error((Throwable)new NotAcceptableStatusException(mediaTypes));
    }

    private ResolvableType getElementType(ReactiveAdapter adapter, ResolvableType genericType) {
        if (adapter.isNoValue()) {
            return ResolvableType.forClass(Void.class);
        }
        if (genericType != ResolvableType.NONE) {
            return genericType;
        }
        return ResolvableType.forClass(Object.class);
    }

    private List<MediaType> getMediaTypesFor(ResolvableType elementType) {
        return this.getMessageWriters().stream().filter(converter -> converter.canWrite(elementType, null)).flatMap(converter -> converter.getWritableMediaTypes().stream()).collect(Collectors.toList());
    }
}

