/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.UnsupportedMediaTypeException;
import reactor.core.publisher.Mono;

public abstract class BodyInserters {
    private static final ResolvableType RESOURCE_TYPE = ResolvableType.forClass(Resource.class);
    private static final ResolvableType SERVER_SIDE_EVENT_TYPE = ResolvableType.forClass(ServerSentEvent.class);
    private static final ResolvableType FORM_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, (Class[])new Class[]{String.class, String.class});
    private static final ResolvableType MULTIPART_VALUE_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, (Class[])new Class[]{String.class, Object.class});
    private static final BodyInserter<Void, ReactiveHttpOutputMessage> EMPTY = (response, context) -> response.setComplete();

    public static <T> BodyInserter<T, ReactiveHttpOutputMessage> empty() {
        return EMPTY;
    }

    public static <T> BodyInserter<T, ReactiveHttpOutputMessage> fromObject(T body2) {
        Assert.notNull(body2, (String)"'body' must not be null");
        return BodyInserters.bodyInserterFor(Mono.just(body2), ResolvableType.forInstance(body2));
    }

    public static <T, P extends Publisher<T>> BodyInserter<P, ReactiveHttpOutputMessage> fromPublisher(P publisher, Class<T> elementClass) {
        Assert.notNull(publisher, (String)"'publisher' must not be null");
        Assert.notNull(elementClass, (String)"'elementClass' must not be null");
        return BodyInserters.bodyInserterFor(publisher, ResolvableType.forClass(elementClass));
    }

    public static <T, P extends Publisher<T>> BodyInserter<P, ReactiveHttpOutputMessage> fromPublisher(P publisher, ParameterizedTypeReference<T> typeReference) {
        Assert.notNull(publisher, (String)"'publisher' must not be null");
        Assert.notNull(typeReference, (String)"'typeReference' must not be null");
        return BodyInserters.bodyInserterFor(publisher, ResolvableType.forType((Type)typeReference.getType()));
    }

    public static <T extends Resource> BodyInserter<T, ReactiveHttpOutputMessage> fromResource(T resource) {
        Assert.notNull(resource, (String)"'resource' must not be null");
        return (outputMessage, context) -> {
            Mono inputStream = Mono.just((Object)resource);
            HttpMessageWriter<Resource> messageWriter = BodyInserters.resourceHttpMessageWriter(context);
            Optional<ServerHttpRequest> serverRequest = context.serverRequest();
            if (serverRequest.isPresent() && outputMessage instanceof ServerHttpResponse) {
                return messageWriter.write((Publisher)inputStream, RESOURCE_TYPE, RESOURCE_TYPE, null, serverRequest.get(), (ServerHttpResponse)outputMessage, context.hints());
            }
            return messageWriter.write((Publisher)inputStream, RESOURCE_TYPE, null, outputMessage, context.hints());
        };
    }

    private static HttpMessageWriter<Resource> resourceHttpMessageWriter(BodyInserter.Context context) {
        return context.messageWriters().stream().filter(messageWriter -> messageWriter.canWrite(RESOURCE_TYPE, null)).findFirst().map(BodyInserters::cast).orElseThrow(() -> new IllegalStateException("Could not find HttpMessageWriter that supports Resource objects"));
    }

    public static <T, S extends Publisher<ServerSentEvent<T>>> BodyInserter<S, ServerHttpResponse> fromServerSentEvents(S eventsPublisher) {
        Assert.notNull(eventsPublisher, (String)"'eventsPublisher' must not be null");
        return (serverResponse, context) -> {
            HttpMessageWriter messageWriter = BodyInserters.findMessageWriter(context, SERVER_SIDE_EVENT_TYPE, MediaType.TEXT_EVENT_STREAM);
            return context.serverRequest().map(serverRequest -> messageWriter.write(eventsPublisher, SERVER_SIDE_EVENT_TYPE, SERVER_SIDE_EVENT_TYPE, MediaType.TEXT_EVENT_STREAM, serverRequest, serverResponse, context.hints())).orElseGet(() -> messageWriter.write(eventsPublisher, SERVER_SIDE_EVENT_TYPE, MediaType.TEXT_EVENT_STREAM, serverResponse, context.hints()));
        };
    }

    public static FormInserter<String> fromFormData(MultiValueMap<String, String> formData) {
        Assert.notNull(formData, (String)"'formData' must not be null");
        return DefaultFormInserter.forFormData().with(formData);
    }

    public static FormInserter<String> fromFormData(String key, String value) {
        Assert.notNull((Object)key, (String)"'key' must not be null");
        Assert.notNull((Object)value, (String)"'value' must not be null");
        return DefaultFormInserter.forFormData().with(key, value);
    }

    public static <T> FormInserter<T> fromMultipartData(MultiValueMap<String, T> multipartData) {
        Assert.notNull(multipartData, (String)"'multipartData' must not be null");
        return DefaultFormInserter.forMultipartData().with(multipartData);
    }

    public static <T> FormInserter<T> fromMultipartData(String key, T value) {
        Assert.notNull((Object)key, (String)"'key' must not be null");
        Assert.notNull(value, (String)"'value' must not be null");
        return DefaultFormInserter.forMultipartData().with(key, value);
    }

    public static <T extends Publisher<DataBuffer>> BodyInserter<T, ReactiveHttpOutputMessage> fromDataBuffers(T publisher) {
        Assert.notNull(publisher, (String)"'publisher' must not be null");
        return (outputMessage, context) -> outputMessage.writeWith(publisher);
    }

    private static <T, P extends Publisher<?>, M extends ReactiveHttpOutputMessage> BodyInserter<T, M> bodyInserterFor(P body2, ResolvableType bodyType) {
        return (outputMessage, context) -> {
            MediaType contentType2 = outputMessage.getHeaders().getContentType();
            List<HttpMessageWriter<?>> messageWriters = context.messageWriters();
            return messageWriters.stream().filter(messageWriter -> messageWriter.canWrite(bodyType, contentType2)).findFirst().map(BodyInserters::cast).map(messageWriter -> {
                Optional<ServerHttpRequest> serverRequest = context.serverRequest();
                if (serverRequest.isPresent() && outputMessage instanceof ServerHttpResponse) {
                    return messageWriter.write(body2, bodyType, bodyType, contentType2, serverRequest.get(), (ServerHttpResponse)outputMessage, context.hints());
                }
                return messageWriter.write(body2, bodyType, contentType2, outputMessage, context.hints());
            }).orElseGet(() -> {
                List<MediaType> supportedMediaTypes = messageWriters.stream().flatMap(reader -> reader.getWritableMediaTypes().stream()).collect(Collectors.toList());
                UnsupportedMediaTypeException error = new UnsupportedMediaTypeException(contentType2, supportedMediaTypes);
                return Mono.error((Throwable)((Object)error));
            });
        };
    }

    private static <T> HttpMessageWriter<T> findMessageWriter(BodyInserter.Context context, ResolvableType type, MediaType mediaType) {
        return context.messageWriters().stream().filter(messageWriter -> messageWriter.canWrite(type, mediaType)).findFirst().map(BodyInserters::cast).orElseThrow(() -> new IllegalStateException("Could not find HttpMessageWriter that supports " + mediaType));
    }

    private static <T> HttpMessageWriter<T> cast(HttpMessageWriter<?> messageWriter) {
        return messageWriter;
    }

    private static class DefaultFormInserter<T>
    implements FormInserter<T> {
        private final MultiValueMap<String, T> data = new LinkedMultiValueMap();
        private final ResolvableType type;
        private final MediaType mediaType;

        private DefaultFormInserter(ResolvableType type, MediaType mediaType) {
            this.type = type;
            this.mediaType = mediaType;
        }

        public static FormInserter<String> forFormData() {
            return new DefaultFormInserter<String>(FORM_TYPE, MediaType.APPLICATION_FORM_URLENCODED);
        }

        public static <T> FormInserter<T> forMultipartData() {
            return new DefaultFormInserter<T>(MULTIPART_VALUE_TYPE, MediaType.MULTIPART_FORM_DATA);
        }

        @Override
        public FormInserter<T> with(String key, @Nullable T value) {
            this.data.add((Object)key, value);
            return this;
        }

        @Override
        public FormInserter<T> with(MultiValueMap<String, T> values) {
            this.data.addAll(values);
            return this;
        }

        @Override
        public Mono<Void> insert(ClientHttpRequest outputMessage, BodyInserter.Context context) {
            HttpMessageWriter messageWriter = BodyInserters.findMessageWriter(context, this.type, this.mediaType);
            return messageWriter.write((Publisher)Mono.just(this.data), this.type, this.mediaType, (ReactiveHttpOutputMessage)outputMessage, context.hints());
        }
    }

    public static interface FormInserter<T>
    extends BodyInserter<MultiValueMap<String, T>, ClientHttpRequest> {
        public FormInserter<T> with(String var1, @Nullable T var2);

        public FormInserter<T> with(MultiValueMap<String, T> var1);
    }
}

