/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.util.logging.Level;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.DefaultClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

public abstract class ExchangeFunctions {
    public static ExchangeFunction create(ClientHttpConnector connector) {
        return ExchangeFunctions.create(connector, ExchangeStrategies.withDefaults());
    }

    public static ExchangeFunction create(ClientHttpConnector connector, ExchangeStrategies strategies) {
        Assert.notNull((Object)connector, (String)"'connector' must not be null");
        Assert.notNull((Object)strategies, (String)"'strategies' must not be null");
        return new DefaultExchangeFunction(connector, strategies);
    }

    private static class DefaultExchangeFunction
    implements ExchangeFunction {
        private final ClientHttpConnector connector;
        private final ExchangeStrategies strategies;

        public DefaultExchangeFunction(ClientHttpConnector connector, ExchangeStrategies strategies) {
            this.connector = connector;
            this.strategies = strategies;
        }

        @Override
        public Mono<ClientResponse> exchange(ClientRequest request) {
            Assert.notNull((Object)request, (String)"'request' must not be null");
            return this.connector.connect(request.method(), request.url(), clientHttpRequest -> request.writeTo((ClientHttpRequest)clientHttpRequest, this.strategies)).log("org.springframework.web.reactive.function.client", Level.FINE, new SignalType[0]).map(clientHttpResponse -> new DefaultClientResponse((ClientHttpResponse)clientHttpResponse, this.strategies));
        }
    }
}

