/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.reflect.Executable;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ErrorsMethodArgumentResolver
extends HandlerMethodArgumentResolverSupport {
    public ErrorsMethodArgumentResolver(ReactiveAdapterRegistry registry) {
        super(registry);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.checkParameterType(parameter, Errors.class::isAssignableFrom);
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext context, ServerWebExchange exchange) {
        Object errors = this.getErrors(parameter, context);
        if (Mono.class.isAssignableFrom(errors.getClass())) {
            return ((Mono)errors).cast(Object.class);
        }
        if (Errors.class.isAssignableFrom(errors.getClass())) {
            return Mono.just((Object)errors);
        }
        throw new IllegalStateException("Unexpected Errors/BindingResult type: " + errors.getClass().getName());
    }

    private Object getErrors(MethodParameter parameter, BindingContext context) {
        Assert.isTrue((parameter.getParameterIndex() > 0 ? 1 : 0) != 0, (String)"Errors argument must be immediately after a model attribute argument");
        int index = parameter.getParameterIndex() - 1;
        MethodParameter attributeParam = MethodParameter.forExecutable((Executable)parameter.getExecutable(), (int)index);
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(attributeParam.getParameterType());
        Assert.isNull((Object)adapter, (String)"An @ModelAttribute and an Errors/BindingResult) arguments cannot both be declared with an async type wrapper. Either declare the @ModelAttribute without an async wrapper type or handle a WebExchangeBindException error signal through the async type.");
        ModelAttribute annot = (ModelAttribute)parameter.getParameterAnnotation(ModelAttribute.class);
        String name = annot != null && StringUtils.hasText((String)annot.value()) ? annot.value() : Conventions.getVariableNameForParameter((MethodParameter)attributeParam);
        Object errors = context.getModel().asMap().get(BindingResult.MODEL_KEY_PREFIX + name);
        Assert.notNull(errors, (String)("An Errors/BindingResult argument is expected immediately after the @ModelAttribute argument to which it applies. For @RequestBody and @RequestPart arguments, please declare them with a reactive type wrapper and use its onError operators to handle WebExchangeBindException: " + parameter.getMethod()));
        return errors;
    }
}

