/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRange;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.UnsupportedMediaTypeException;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import org.springframework.web.server.WebSession;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultServerRequest
implements ServerRequest {
    private static final Function<UnsupportedMediaTypeException, UnsupportedMediaTypeStatusException> ERROR_MAPPER = ex -> ex.getContentType() != null ? new UnsupportedMediaTypeStatusException(ex.getContentType(), ex.getSupportedMediaTypes()) : new UnsupportedMediaTypeStatusException(ex.getMessage());
    private final ServerWebExchange exchange;
    private final ServerRequest.Headers headers;
    private final List<HttpMessageReader<?>> messageReaders;

    DefaultServerRequest(ServerWebExchange exchange, List<HttpMessageReader<?>> messageReaders) {
        this.exchange = exchange;
        this.messageReaders = Collections.unmodifiableList(new ArrayList(messageReaders));
        this.headers = new DefaultHeaders();
    }

    @Override
    public String methodName() {
        return this.request().getMethodValue();
    }

    @Override
    public URI uri() {
        return this.request().getURI();
    }

    @Override
    public UriBuilder uriBuilder() {
        return UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServerRequestAdapter());
    }

    @Override
    public PathContainer pathContainer() {
        return this.request().getPath();
    }

    @Override
    public ServerRequest.Headers headers() {
        return this.headers;
    }

    @Override
    public MultiValueMap<String, HttpCookie> cookies() {
        return this.request().getCookies();
    }

    @Override
    public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> extractor) {
        return this.body(extractor, Collections.emptyMap());
    }

    @Override
    public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> extractor, final Map<String, Object> hints) {
        return extractor.extract((ServerHttpRequest)this.request(), new BodyExtractor.Context(){

            @Override
            public List<HttpMessageReader<?>> messageReaders() {
                return DefaultServerRequest.this.messageReaders;
            }

            @Override
            public Optional<ServerHttpResponse> serverResponse() {
                return Optional.of(DefaultServerRequest.this.exchange().getResponse());
            }

            @Override
            public Map<String, Object> hints() {
                return hints;
            }
        });
    }

    @Override
    public <T> Mono<T> bodyToMono(Class<? extends T> elementClass) {
        Mono<? extends T> mono = this.body(BodyExtractors.toMono(elementClass));
        return mono.onErrorMap(UnsupportedMediaTypeException.class, ERROR_MAPPER);
    }

    @Override
    public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> typeReference) {
        Mono<T> mono = this.body(BodyExtractors.toMono(typeReference));
        return mono.onErrorMap(UnsupportedMediaTypeException.class, ERROR_MAPPER);
    }

    @Override
    public <T> Flux<T> bodyToFlux(Class<? extends T> elementClass) {
        Flux<? extends T> flux = this.body(BodyExtractors.toFlux(elementClass));
        return flux.onErrorMap(UnsupportedMediaTypeException.class, ERROR_MAPPER);
    }

    @Override
    public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> typeReference) {
        Flux<T> flux = this.body(BodyExtractors.toFlux(typeReference));
        return flux.onErrorMap(UnsupportedMediaTypeException.class, ERROR_MAPPER);
    }

    @Override
    public Map<String, Object> attributes() {
        return this.exchange.getAttributes();
    }

    @Override
    public MultiValueMap<String, String> queryParams() {
        return this.request().getQueryParams();
    }

    @Override
    public Map<String, String> pathVariables() {
        return (Map)this.exchange.getAttributeOrDefault(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE, Collections.emptyMap());
    }

    @Override
    public Mono<WebSession> session() {
        return this.exchange.getSession();
    }

    @Override
    public Mono<? extends Principal> principal() {
        return this.exchange.getPrincipal();
    }

    @Override
    public Mono<MultiValueMap<String, String>> formData() {
        return this.exchange.getFormData();
    }

    @Override
    public Mono<MultiValueMap<String, Part>> multipartData() {
        return this.exchange.getMultipartData();
    }

    private ServerHttpRequest request() {
        return this.exchange.getRequest();
    }

    ServerWebExchange exchange() {
        return this.exchange;
    }

    public String toString() {
        return String.format("%s %s", this.method(), this.path());
    }

    private final class ServerRequestAdapter
    implements HttpRequest {
        private ServerRequestAdapter() {
        }

        public String getMethodValue() {
            return DefaultServerRequest.this.methodName();
        }

        public URI getURI() {
            return DefaultServerRequest.this.uri();
        }

        public HttpHeaders getHeaders() {
            return DefaultServerRequest.this.request().getHeaders();
        }
    }

    private class DefaultHeaders
    implements ServerRequest.Headers {
        private DefaultHeaders() {
        }

        private HttpHeaders delegate() {
            return DefaultServerRequest.this.request().getHeaders();
        }

        @Override
        public List<MediaType> accept() {
            return this.delegate().getAccept();
        }

        @Override
        public List<Charset> acceptCharset() {
            return this.delegate().getAcceptCharset();
        }

        @Override
        public List<Locale.LanguageRange> acceptLanguage() {
            return this.delegate().getAcceptLanguage();
        }

        @Override
        public OptionalLong contentLength() {
            long value = this.delegate().getContentLength();
            return value != -1L ? OptionalLong.of(value) : OptionalLong.empty();
        }

        @Override
        public Optional<MediaType> contentType() {
            return Optional.ofNullable(this.delegate().getContentType());
        }

        @Override
        public InetSocketAddress host() {
            return this.delegate().getHost();
        }

        @Override
        public List<HttpRange> range() {
            return this.delegate().getRange();
        }

        @Override
        public List<String> header(String headerName) {
            List<String> headerValues = this.delegate().get((Object)headerName);
            return headerValues != null ? headerValues : Collections.emptyList();
        }

        @Override
        public HttpHeaders asHttpHeaders() {
            return HttpHeaders.readOnlyHttpHeaders((HttpHeaders)this.delegate());
        }

        public String toString() {
            return this.delegate().toString();
        }
    }
}

