/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.codec.ResourceHttpMessageWriter;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.resource.DefaultResourceResolverChain;
import org.springframework.web.reactive.resource.DefaultResourceTransformerChain;
import org.springframework.web.reactive.resource.HttpResource;
import org.springframework.web.reactive.resource.PathResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.reactive.resource.ResourceTransformer;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Mono;

public class ResourceWebHandler
implements WebHandler,
InitializingBean {
    private static final Set<HttpMethod> SUPPORTED_METHODS = EnumSet.of(HttpMethod.GET, HttpMethod.HEAD);
    private static final ResponseStatusException NOT_FOUND_EXCEPTION = new ResponseStatusException(HttpStatus.NOT_FOUND);
    private static final Log logger = LogFactory.getLog(ResourceWebHandler.class);
    private final List<Resource> locations = new ArrayList<Resource>(4);
    private final List<ResourceResolver> resourceResolvers = new ArrayList<ResourceResolver>(4);
    private final List<ResourceTransformer> resourceTransformers = new ArrayList<ResourceTransformer>(4);
    @Nullable
    private ResourceResolverChain resolverChain;
    @Nullable
    private ResourceTransformerChain transformerChain;
    @Nullable
    private CacheControl cacheControl;
    @Nullable
    private ResourceHttpMessageWriter resourceHttpMessageWriter;

    public void setLocations(@Nullable List<Resource> locations) {
        this.locations.clear();
        if (locations != null) {
            this.locations.addAll(locations);
        }
    }

    public List<Resource> getLocations() {
        return this.locations;
    }

    public void setResourceResolvers(@Nullable List<ResourceResolver> resourceResolvers) {
        this.resourceResolvers.clear();
        if (resourceResolvers != null) {
            this.resourceResolvers.addAll(resourceResolvers);
        }
    }

    public List<ResourceResolver> getResourceResolvers() {
        return this.resourceResolvers;
    }

    public void setResourceTransformers(@Nullable List<ResourceTransformer> resourceTransformers) {
        this.resourceTransformers.clear();
        if (resourceTransformers != null) {
            this.resourceTransformers.addAll(resourceTransformers);
        }
    }

    public List<ResourceTransformer> getResourceTransformers() {
        return this.resourceTransformers;
    }

    public void setCacheControl(@Nullable CacheControl cacheControl) {
        this.cacheControl = cacheControl;
    }

    @Nullable
    public CacheControl getCacheControl() {
        return this.cacheControl;
    }

    public void setResourceHttpMessageWriter(@Nullable ResourceHttpMessageWriter httpMessageWriter) {
        this.resourceHttpMessageWriter = httpMessageWriter;
    }

    @Nullable
    public ResourceHttpMessageWriter getResourceHttpMessageWriter() {
        return this.resourceHttpMessageWriter;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.resourceResolvers.isEmpty()) {
            this.resourceResolvers.add(new PathResourceResolver());
        }
        this.initAllowedLocations();
        if (this.getResourceHttpMessageWriter() == null) {
            this.resourceHttpMessageWriter = new ResourceHttpMessageWriter();
        }
        this.resolverChain = new DefaultResourceResolverChain(this.resourceResolvers);
        this.transformerChain = new DefaultResourceTransformerChain(this.resolverChain, this.resourceTransformers);
    }

    protected void initAllowedLocations() {
        if (CollectionUtils.isEmpty(this.locations)) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"Locations list is empty. No resources will be served unless a custom ResourceResolver is configured as an alternative to PathResourceResolver.");
            }
            return;
        }
        for (int i = this.getResourceResolvers().size() - 1; i >= 0; --i) {
            if (!(this.getResourceResolvers().get(i) instanceof PathResourceResolver)) continue;
            PathResourceResolver resolver = (PathResourceResolver)this.getResourceResolvers().get(i);
            if (!ObjectUtils.isEmpty((Object[])resolver.getAllowedLocations())) break;
            resolver.setAllowedLocations(this.getLocations().toArray(new Resource[0]));
            break;
        }
    }

    public Mono<Void> handle(ServerWebExchange exchange) {
        return this.getResource(exchange).switchIfEmpty(Mono.defer(() -> {
            logger.trace((Object)"No matching resource found - returning 404");
            return Mono.error((Throwable)NOT_FOUND_EXCEPTION);
        })).flatMap(resource -> {
            try {
                MediaType mediaType;
                String ccValue;
                if (HttpMethod.OPTIONS.matches(exchange.getRequest().getMethodValue())) {
                    exchange.getResponse().getHeaders().add("Allow", "GET,HEAD,OPTIONS");
                    return Mono.empty();
                }
                HttpMethod httpMethod = exchange.getRequest().getMethod();
                if (!SUPPORTED_METHODS.contains(httpMethod)) {
                    return Mono.error((Throwable)new MethodNotAllowedException(exchange.getRequest().getMethodValue(), SUPPORTED_METHODS));
                }
                if (exchange.checkNotModified(Instant.ofEpochMilli(resource.lastModified()))) {
                    logger.trace((Object)"Resource not modified - returning 304");
                    return Mono.empty();
                }
                if (this.getCacheControl() != null && (ccValue = this.getCacheControl().getHeaderValue()) != null) {
                    exchange.getResponse().getHeaders().setCacheControl(ccValue);
                }
                if ((mediaType = (MediaType)MediaTypeFactory.getMediaType((Resource)resource).orElse(null)) != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Determined media type '" + mediaType + "' for " + resource));
                    }
                } else if (logger.isTraceEnabled()) {
                    logger.trace((Object)("No media type found for " + resource + " - not sending a content-type header"));
                }
                if (HttpMethod.HEAD.matches(exchange.getRequest().getMethodValue())) {
                    this.setHeaders(exchange, (Resource)resource, mediaType);
                    exchange.getResponse().getHeaders().set("Accept-Ranges", "bytes");
                    logger.trace((Object)"HEAD request - skipping content");
                    return Mono.empty();
                }
                this.setHeaders(exchange, (Resource)resource, mediaType);
                ResourceHttpMessageWriter writer = this.getResourceHttpMessageWriter();
                Assert.state((writer != null ? 1 : 0) != 0, (String)"No ResourceHttpMessageWriter");
                return writer.write((Publisher)Mono.just((Object)resource), null, ResolvableType.forClass(Resource.class), mediaType, exchange.getRequest(), exchange.getResponse(), Collections.emptyMap());
            }
            catch (IOException ex) {
                return Mono.error((Throwable)ex);
            }
        });
    }

    protected Mono<Resource> getResource(ServerWebExchange exchange) {
        String name = HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE;
        PathContainer pathWithinHandler = (PathContainer)exchange.getRequiredAttribute(name);
        String path2 = this.processPath(pathWithinHandler.value());
        if (!StringUtils.hasText((String)path2) || this.isInvalidPath(path2)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ignoring invalid resource path [" + path2 + "]"));
            }
            return Mono.empty();
        }
        if (this.isInvalidEncodedPath(path2)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ignoring invalid resource path with escape sequences [" + path2 + "]"));
            }
            return Mono.empty();
        }
        Assert.state((this.resolverChain != null ? 1 : 0) != 0, (String)"ResourceResolverChain not initialized");
        Assert.state((this.transformerChain != null ? 1 : 0) != 0, (String)"ResourceTransformerChain not initialized");
        return this.resolverChain.resolveResource(exchange, path2, this.getLocations()).flatMap(resource -> this.transformerChain.transform(exchange, (Resource)resource));
    }

    protected String processPath(String path2) {
        path2 = StringUtils.replace((String)path2, (String)"\\", (String)"/");
        path2 = this.cleanDuplicateSlashes(path2);
        return this.cleanLeadingSlash(path2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cleanDuplicateSlashes(String path2) {
        StringBuilder sb = null;
        char prev = '\u0000';
        for (int i = 0; i < path2.length(); ++i) {
            char curr = path2.charAt(i);
            try {
                if (curr == '/' && prev == '/') {
                    if (sb != null) continue;
                    sb = new StringBuilder(path2.substring(0, i));
                    continue;
                }
                if (sb == null) continue;
                sb.append(path2.charAt(i));
                continue;
            }
            finally {
                prev = curr;
            }
        }
        return sb != null ? sb.toString() : path2;
    }

    private String cleanLeadingSlash(String path2) {
        boolean slash = false;
        for (int i = 0; i < path2.length(); ++i) {
            if (path2.charAt(i) == '/') {
                slash = true;
                continue;
            }
            if (path2.charAt(i) <= ' ' || path2.charAt(i) == '\u007f') continue;
            if (i == 0 || i == 1 && slash) {
                return path2;
            }
            String string = path2 = slash ? "/" + path2.substring(i) : path2.substring(i);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Path after trimming leading '/' and control characters: " + path2));
            }
            return path2;
        }
        return slash ? "/" : "";
    }

    private boolean isInvalidEncodedPath(String path2) {
        if (path2.contains("%")) {
            try {
                String decodedPath = URLDecoder.decode(path2, "UTF-8");
                if (this.isInvalidPath(decodedPath)) {
                    return true;
                }
                if (this.isInvalidPath(decodedPath = this.processPath(decodedPath))) {
                    return true;
                }
            }
            catch (UnsupportedEncodingException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean isInvalidPath(String path2) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Applying \"invalid path\" checks to path: " + path2));
        }
        if (path2.contains("WEB-INF") || path2.contains("META-INF")) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Path with \"WEB-INF\" or \"META-INF\": [" + path2 + "]"));
            }
            return true;
        }
        if (path2.contains(":/")) {
            String relativePath;
            String string = relativePath = path2.charAt(0) == '/' ? path2.substring(1) : path2;
            if (ResourceUtils.isUrl((String)relativePath) || relativePath.startsWith("url:")) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Path represents URL or has \"url:\" prefix: [" + path2 + "]"));
                }
                return true;
            }
        }
        if (path2.contains("..") && StringUtils.cleanPath((String)path2).contains("../")) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Path contains \"../\" after call to StringUtils#cleanPath: [" + path2 + "]"));
            }
            return true;
        }
        return false;
    }

    protected void setHeaders(ServerWebExchange exchange, Resource resource, @Nullable MediaType mediaType) throws IOException {
        HttpHeaders headers2 = exchange.getResponse().getHeaders();
        long length = resource.contentLength();
        headers2.setContentLength(length);
        if (mediaType != null) {
            headers2.setContentType(mediaType);
        }
        if (resource instanceof HttpResource) {
            HttpHeaders resourceHeaders = ((HttpResource)resource).getResponseHeaders();
            exchange.getResponse().getHeaders().putAll((Map)resourceHeaders);
        }
    }

    public String toString() {
        return "ResourceWebHandler [locations=" + this.getLocations() + ", resolvers=" + this.getResourceResolvers() + "]";
    }
}

