/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server.support;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.handler.AbstractHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RouterFunctionMapping
extends AbstractHandlerMapping
implements InitializingBean {
    @Nullable
    private RouterFunction<?> routerFunction;
    private List<HttpMessageReader<?>> messageReaders = Collections.emptyList();

    public RouterFunctionMapping() {
    }

    public RouterFunctionMapping(RouterFunction<?> routerFunction) {
        this.routerFunction = routerFunction;
    }

    @Nullable
    public RouterFunction<?> getRouterFunction() {
        return this.routerFunction;
    }

    public void setMessageReaders(List<HttpMessageReader<?>> messageReaders) {
        this.messageReaders = messageReaders;
    }

    public void afterPropertiesSet() throws Exception {
        if (CollectionUtils.isEmpty(this.messageReaders)) {
            ServerCodecConfigurer codecConfigurer = ServerCodecConfigurer.create();
            this.messageReaders = codecConfigurer.getReaders();
        }
        if (this.routerFunction == null) {
            this.initRouterFunctions();
        }
    }

    protected void initRouterFunctions() {
        List<RouterFunction<?>> routerFunctions = this.routerFunctions();
        this.routerFunction = routerFunctions.stream().reduce(RouterFunction::andOther).orElse(null);
        this.logRouterFunctions(routerFunctions);
    }

    private List<RouterFunction<?>> routerFunctions() {
        SortedRouterFunctionsContainer container = new SortedRouterFunctionsContainer();
        this.obtainApplicationContext().getAutowireCapableBeanFactory().autowireBean((Object)container);
        List<RouterFunction<?>> functions = container.routerFunctions;
        return !CollectionUtils.isEmpty((Collection)functions) ? functions : Collections.emptyList();
    }

    private void logRouterFunctions(List<RouterFunction<?>> routerFunctions) {
        if (this.logger.isDebugEnabled()) {
            int total = routerFunctions.size();
            String message = total + " RouterFunction(s) in " + this.formatMappingName();
            if (this.logger.isTraceEnabled()) {
                if (total > 0) {
                    routerFunctions.forEach(routerFunction -> this.logger.trace((Object)("Mapped " + routerFunction)));
                } else {
                    this.logger.trace((Object)message);
                }
            } else if (total > 0) {
                this.logger.debug((Object)message);
            }
        }
    }

    @Override
    protected Mono<?> getHandlerInternal(ServerWebExchange exchange) {
        if (this.routerFunction != null) {
            ServerRequest request = ServerRequest.create(exchange, this.messageReaders);
            exchange.getAttributes().put(RouterFunctions.REQUEST_ATTRIBUTE, request);
            return this.routerFunction.route(request);
        }
        return Mono.empty();
    }

    private static class SortedRouterFunctionsContainer {
        @Nullable
        private List<RouterFunction<?>> routerFunctions;

        private SortedRouterFunctionsContainer() {
        }

        @Autowired(required=false)
        public void setRouterFunctions(List<RouterFunction<?>> routerFunctions) {
            this.routerFunctions = routerFunctions;
        }
    }
}

