/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.ControllerAdviceBean;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.annotation.ExceptionHandlerMethodResolver;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.InvocableHandlerMethod;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.SyncInvocableHandlerMethod;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;
import org.springframework.web.reactive.result.method.annotation.CookieValueMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ErrorsMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ExpressionValueMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.HttpEntityArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.MatrixVariableMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.MatrixVariableMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ModelArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ModelAttributeMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.PathVariableMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.PathVariableMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.PrincipalArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestAttributeMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestBodyArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestHeaderMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestHeaderMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestParamMapMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestPartMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ServerWebExchangeArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.SessionAttributeMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.SessionAttributesHandler;
import org.springframework.web.reactive.result.method.annotation.SessionStatusMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.WebSessionArgumentResolver;

class ControllerMethodResolver {
    private static final ReflectionUtils.MethodFilter INIT_BINDER_METHODS = method2 -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method2, InitBinder.class);
    private static final ReflectionUtils.MethodFilter MODEL_ATTRIBUTE_METHODS = method2 -> !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method2, RequestMapping.class) && AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method2, ModelAttribute.class);
    private static final Log logger = LogFactory.getLog(ControllerMethodResolver.class);
    private final List<SyncHandlerMethodArgumentResolver> initBinderResolvers;
    private final List<HandlerMethodArgumentResolver> modelAttributeResolvers;
    private final List<HandlerMethodArgumentResolver> requestMappingResolvers;
    private final List<HandlerMethodArgumentResolver> exceptionHandlerResolvers;
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;
    private final Map<Class<?>, Set<Method>> initBinderMethodCache = new ConcurrentHashMap(64);
    private final Map<Class<?>, Set<Method>> modelAttributeMethodCache = new ConcurrentHashMap(64);
    private final Map<Class<?>, ExceptionHandlerMethodResolver> exceptionHandlerCache = new ConcurrentHashMap(64);
    private final Map<ControllerAdviceBean, Set<Method>> initBinderAdviceCache = new LinkedHashMap<ControllerAdviceBean, Set<Method>>(64);
    private final Map<ControllerAdviceBean, Set<Method>> modelAttributeAdviceCache = new LinkedHashMap<ControllerAdviceBean, Set<Method>>(64);
    private final Map<ControllerAdviceBean, ExceptionHandlerMethodResolver> exceptionHandlerAdviceCache = new LinkedHashMap<ControllerAdviceBean, ExceptionHandlerMethodResolver>(64);
    private final Map<Class<?>, SessionAttributesHandler> sessionAttributesHandlerCache = new ConcurrentHashMap(64);

    ControllerMethodResolver(ArgumentResolverConfigurer customResolvers, ReactiveAdapterRegistry adapterRegistry, ConfigurableApplicationContext context, List<HttpMessageReader<?>> readers) {
        Assert.notNull((Object)customResolvers, (String)"ArgumentResolverConfigurer is required");
        Assert.notNull((Object)adapterRegistry, (String)"ReactiveAdapterRegistry is required");
        Assert.notNull((Object)context, (String)"ApplicationContext is required");
        Assert.notNull(readers, (String)"HttpMessageReader List is required");
        this.initBinderResolvers = this.initBinderResolvers(customResolvers, adapterRegistry, context);
        this.modelAttributeResolvers = ControllerMethodResolver.modelMethodResolvers(customResolvers, adapterRegistry, context);
        this.requestMappingResolvers = ControllerMethodResolver.requestMappingResolvers(customResolvers, adapterRegistry, context, readers);
        this.exceptionHandlerResolvers = ControllerMethodResolver.exceptionHandlerResolvers(customResolvers, adapterRegistry, context);
        this.reactiveAdapterRegistry = adapterRegistry;
        this.initControllerAdviceCaches((ApplicationContext)context);
    }

    private List<SyncHandlerMethodArgumentResolver> initBinderResolvers(ArgumentResolverConfigurer customResolvers, ReactiveAdapterRegistry adapterRegistry, ConfigurableApplicationContext context) {
        return ControllerMethodResolver.initResolvers(customResolvers, adapterRegistry, context, false, Collections.emptyList()).stream().filter(resolver -> resolver instanceof SyncHandlerMethodArgumentResolver).map(resolver -> (SyncHandlerMethodArgumentResolver)resolver).collect(Collectors.toList());
    }

    private static List<HandlerMethodArgumentResolver> modelMethodResolvers(ArgumentResolverConfigurer customResolvers, ReactiveAdapterRegistry adapterRegistry, ConfigurableApplicationContext context) {
        return ControllerMethodResolver.initResolvers(customResolvers, adapterRegistry, context, true, Collections.emptyList());
    }

    private static List<HandlerMethodArgumentResolver> requestMappingResolvers(ArgumentResolverConfigurer customResolvers, ReactiveAdapterRegistry adapterRegistry, ConfigurableApplicationContext context, List<HttpMessageReader<?>> readers) {
        return ControllerMethodResolver.initResolvers(customResolvers, adapterRegistry, context, true, readers);
    }

    private static List<HandlerMethodArgumentResolver> exceptionHandlerResolvers(ArgumentResolverConfigurer customResolvers, ReactiveAdapterRegistry adapterRegistry, ConfigurableApplicationContext context) {
        return ControllerMethodResolver.initResolvers(customResolvers, adapterRegistry, context, false, Collections.emptyList());
    }

    private static List<HandlerMethodArgumentResolver> initResolvers(ArgumentResolverConfigurer customResolvers, ReactiveAdapterRegistry adapterRegistry, ConfigurableApplicationContext context, boolean supportDataBinding, List<HttpMessageReader<?>> readers) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        boolean requestMappingMethod = !readers.isEmpty() && supportDataBinding;
        ArrayList<HandlerMethodArgumentResolver> result = new ArrayList<HandlerMethodArgumentResolver>(30);
        result.add(new RequestParamMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry, false));
        result.add(new RequestParamMapMethodArgumentResolver(adapterRegistry));
        result.add(new PathVariableMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry));
        result.add(new PathVariableMapMethodArgumentResolver(adapterRegistry));
        result.add(new MatrixVariableMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry));
        result.add(new MatrixVariableMapMethodArgumentResolver(adapterRegistry));
        if (!readers.isEmpty()) {
            result.add(new RequestBodyArgumentResolver(readers, adapterRegistry));
            result.add(new RequestPartMethodArgumentResolver(readers, adapterRegistry));
        }
        if (supportDataBinding) {
            result.add(new ModelAttributeMethodArgumentResolver(adapterRegistry, false));
        }
        result.add(new RequestHeaderMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry));
        result.add(new RequestHeaderMapMethodArgumentResolver(adapterRegistry));
        result.add(new CookieValueMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry));
        result.add(new ExpressionValueMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry));
        result.add(new SessionAttributeMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry));
        result.add(new RequestAttributeMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry));
        if (!readers.isEmpty()) {
            result.add(new HttpEntityArgumentResolver(readers, adapterRegistry));
        }
        result.add(new ModelArgumentResolver(adapterRegistry));
        if (supportDataBinding) {
            result.add(new ErrorsMethodArgumentResolver(adapterRegistry));
        }
        result.add(new ServerWebExchangeArgumentResolver(adapterRegistry));
        result.add(new PrincipalArgumentResolver(adapterRegistry));
        if (requestMappingMethod) {
            result.add(new SessionStatusMethodArgumentResolver());
        }
        result.add(new WebSessionArgumentResolver(adapterRegistry));
        result.addAll(customResolvers.getCustomResolvers());
        result.add(new RequestParamMethodArgumentResolver((ConfigurableBeanFactory)beanFactory, adapterRegistry, true));
        if (supportDataBinding) {
            result.add(new ModelAttributeMethodArgumentResolver(adapterRegistry, true));
        }
        return result;
    }

    private void initControllerAdviceCaches(ApplicationContext applicationContext) {
        List beans = ControllerAdviceBean.findAnnotatedBeans((ApplicationContext)applicationContext);
        AnnotationAwareOrderComparator.sort((List)beans);
        for (ControllerAdviceBean bean : beans) {
            ExceptionHandlerMethodResolver resolver;
            Set binderMethods;
            Class beanType = bean.getBeanType();
            if (beanType == null) continue;
            Set attrMethods = MethodIntrospector.selectMethods((Class)beanType, (ReflectionUtils.MethodFilter)MODEL_ATTRIBUTE_METHODS);
            if (!attrMethods.isEmpty()) {
                this.modelAttributeAdviceCache.put(bean, attrMethods);
            }
            if (!(binderMethods = MethodIntrospector.selectMethods((Class)beanType, (ReflectionUtils.MethodFilter)INIT_BINDER_METHODS)).isEmpty()) {
                this.initBinderAdviceCache.put(bean, binderMethods);
            }
            if (!(resolver = new ExceptionHandlerMethodResolver(beanType)).hasExceptionMappings()) continue;
            this.exceptionHandlerAdviceCache.put(bean, resolver);
        }
        if (logger.isDebugEnabled()) {
            int modelSize = this.modelAttributeAdviceCache.size();
            int binderSize = this.initBinderAdviceCache.size();
            int handlerSize = this.exceptionHandlerAdviceCache.size();
            if (modelSize == 0 && binderSize == 0 && handlerSize == 0) {
                logger.debug((Object)"ControllerAdvice beans: none");
            } else {
                logger.debug((Object)("ControllerAdvice beans: " + modelSize + " @ModelAttribute, " + binderSize + " @InitBinder, " + handlerSize + " @ExceptionHandler"));
            }
        }
    }

    public InvocableHandlerMethod getRequestMappingMethod(HandlerMethod handlerMethod) {
        InvocableHandlerMethod invocable = new InvocableHandlerMethod(handlerMethod);
        invocable.setArgumentResolvers(this.requestMappingResolvers);
        invocable.setReactiveAdapterRegistry(this.reactiveAdapterRegistry);
        return invocable;
    }

    public List<SyncInvocableHandlerMethod> getInitBinderMethods(HandlerMethod handlerMethod) {
        ArrayList<SyncInvocableHandlerMethod> result = new ArrayList<SyncInvocableHandlerMethod>();
        Class handlerType = handlerMethod.getBeanType();
        this.initBinderAdviceCache.forEach((adviceBean, methods) -> {
            if (adviceBean.isApplicableToBeanType(handlerType)) {
                Object bean = adviceBean.resolveBean();
                methods.forEach(method2 -> result.add(this.getInitBinderMethod(bean, (Method)method2)));
            }
        });
        this.initBinderMethodCache.computeIfAbsent(handlerType, clazz -> MethodIntrospector.selectMethods((Class)handlerType, (ReflectionUtils.MethodFilter)INIT_BINDER_METHODS)).forEach(method2 -> {
            Object bean = handlerMethod.getBean();
            result.add(this.getInitBinderMethod(bean, (Method)method2));
        });
        return result;
    }

    private SyncInvocableHandlerMethod getInitBinderMethod(Object bean, Method method2) {
        SyncInvocableHandlerMethod invocable = new SyncInvocableHandlerMethod(bean, method2);
        invocable.setArgumentResolvers(this.initBinderResolvers);
        return invocable;
    }

    public List<InvocableHandlerMethod> getModelAttributeMethods(HandlerMethod handlerMethod) {
        ArrayList<InvocableHandlerMethod> result = new ArrayList<InvocableHandlerMethod>();
        Class handlerType = handlerMethod.getBeanType();
        this.modelAttributeAdviceCache.forEach((adviceBean, methods) -> {
            if (adviceBean.isApplicableToBeanType(handlerType)) {
                Object bean = adviceBean.resolveBean();
                methods.forEach(method2 -> result.add(this.createAttributeMethod(bean, (Method)method2)));
            }
        });
        this.modelAttributeMethodCache.computeIfAbsent(handlerType, clazz -> MethodIntrospector.selectMethods((Class)handlerType, (ReflectionUtils.MethodFilter)MODEL_ATTRIBUTE_METHODS)).forEach(method2 -> {
            Object bean = handlerMethod.getBean();
            result.add(this.createAttributeMethod(bean, (Method)method2));
        });
        return result;
    }

    private InvocableHandlerMethod createAttributeMethod(Object bean, Method method2) {
        InvocableHandlerMethod invocable = new InvocableHandlerMethod(bean, method2);
        invocable.setArgumentResolvers(this.modelAttributeResolvers);
        return invocable;
    }

    @Nullable
    public InvocableHandlerMethod getExceptionHandlerMethod(Throwable ex, HandlerMethod handlerMethod) {
        Class handlerType = handlerMethod.getBeanType();
        Object targetBean = handlerMethod.getBean();
        Method targetMethod = this.exceptionHandlerCache.computeIfAbsent(handlerType, ExceptionHandlerMethodResolver::new).resolveMethodByThrowable(ex);
        if (targetMethod == null) {
            for (ControllerAdviceBean advice : this.exceptionHandlerAdviceCache.keySet()) {
                if (!advice.isApplicableToBeanType(handlerType)) continue;
                targetBean = advice.resolveBean();
                targetMethod = this.exceptionHandlerAdviceCache.get(advice).resolveMethodByThrowable(ex);
                if (targetMethod == null) continue;
                break;
            }
        }
        if (targetMethod == null) {
            return null;
        }
        InvocableHandlerMethod invocable = new InvocableHandlerMethod(targetBean, targetMethod);
        invocable.setArgumentResolvers(this.exceptionHandlerResolvers);
        return invocable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionAttributesHandler getSessionAttributesHandler(HandlerMethod handlerMethod) {
        Class handlerType = handlerMethod.getBeanType();
        SessionAttributesHandler result = this.sessionAttributesHandlerCache.get(handlerType);
        if (result == null) {
            Map<Class<?>, SessionAttributesHandler> map = this.sessionAttributesHandlerCache;
            synchronized (map) {
                result = this.sessionAttributesHandlerCache.get(handlerType);
                if (result == null) {
                    result = new SessionAttributesHandler(handlerType);
                    this.sessionAttributesHandlerCache.put(handlerType, result);
                }
            }
        }
        return result;
    }
}

