/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.core.codec.CodecException;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClientException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class WebClientUtils {
    private static final String VALUE_NONE = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n";

    WebClientUtils() {
    }

    public static <T> Mono<ResponseEntity<T>> mapToEntity(ClientResponse response, Mono<T> bodyMono) {
        return bodyMono.defaultIfEmpty((Object)VALUE_NONE).map(body2 -> ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)response.rawStatusCode()).headers(response.headers().asHttpHeaders())).body(body2 != VALUE_NONE ? body2 : null));
    }

    public static <T> Mono<ResponseEntity<List<T>>> mapToEntityList(ClientResponse response, Publisher<T> body2) {
        return Flux.from(body2).collectList().map(list -> ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)response.rawStatusCode()).headers(response.headers().asHttpHeaders())).body(list));
    }

    public static boolean shouldWrapException(Throwable t) {
        return !(t instanceof WebClientException) && !(t instanceof CodecException);
    }
}

