/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.reactivestreams.Subscriber;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketSession;

@WebSocket
public class Jetty10WebSocketHandlerAdapter {
    private static final ByteBuffer EMPTY_PAYLOAD = ByteBuffer.wrap(new byte[0]);
    private final WebSocketHandler delegateHandler;
    private final Function<Session, JettyWebSocketSession> sessionFactory;
    @Nullable
    private JettyWebSocketSession delegateSession;

    public Jetty10WebSocketHandlerAdapter(WebSocketHandler handler, Function<Session, JettyWebSocketSession> sessionFactory) {
        Assert.notNull((Object)handler, (String)"WebSocketHandler is required");
        Assert.notNull(sessionFactory, (String)"'sessionFactory' is required");
        this.delegateHandler = handler;
        this.sessionFactory = sessionFactory;
    }

    @OnWebSocketConnect
    public void onWebSocketConnect(Session session) {
        this.delegateSession = this.sessionFactory.apply(session);
        this.delegateHandler.handle(this.delegateSession).checkpoint(session.getUpgradeRequest().getRequestURI() + " [JettyWebSocketHandlerAdapter]").subscribe((Subscriber)this.delegateSession);
    }

    @OnWebSocketMessage
    public void onWebSocketText(String message) {
        if (this.delegateSession != null) {
            WebSocketMessage webSocketMessage = this.toMessage(WebSocketMessage.Type.TEXT, message);
            this.delegateSession.handleMessage(webSocketMessage.getType(), webSocketMessage);
        }
    }

    @OnWebSocketMessage
    public void onWebSocketBinary(byte[] message, int offset, int length) {
        if (this.delegateSession != null) {
            ByteBuffer buffer = ByteBuffer.wrap(message, offset, length);
            WebSocketMessage webSocketMessage = this.toMessage(WebSocketMessage.Type.BINARY, buffer);
            this.delegateSession.handleMessage(webSocketMessage.getType(), webSocketMessage);
        }
    }

    private <T> WebSocketMessage toMessage(WebSocketMessage.Type type, T message) {
        JettyWebSocketSession session = this.delegateSession;
        Assert.state((session != null ? 1 : 0) != 0, (String)"Cannot create message without a session");
        if (WebSocketMessage.Type.TEXT.equals((Object)type)) {
            byte[] bytes = ((String)message).getBytes(StandardCharsets.UTF_8);
            DataBuffer buffer = session.bufferFactory().wrap(bytes);
            return new WebSocketMessage(WebSocketMessage.Type.TEXT, buffer);
        }
        if (WebSocketMessage.Type.BINARY.equals((Object)type)) {
            DataBuffer buffer = session.bufferFactory().wrap((ByteBuffer)message);
            return new WebSocketMessage(WebSocketMessage.Type.BINARY, buffer);
        }
        if (WebSocketMessage.Type.PONG.equals((Object)type)) {
            DataBuffer buffer = session.bufferFactory().wrap((ByteBuffer)message);
            return new WebSocketMessage(WebSocketMessage.Type.PONG, buffer);
        }
        throw new IllegalArgumentException("Unexpected message type: " + message);
    }

    @OnWebSocketClose
    public void onWebSocketClose(int statusCode, String reason) {
        if (this.delegateSession != null) {
            this.delegateSession.handleClose(CloseStatus.create(statusCode, reason));
        }
    }

    @OnWebSocketError
    public void onWebSocketError(Throwable cause) {
        if (this.delegateSession != null) {
            this.delegateSession.handleError(cause);
        }
    }
}

