/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.lang.Nullable;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueSyncArgumentResolver;
import org.springframework.web.server.ServerErrorException;
import org.springframework.web.server.ServerWebExchange;

public class PathVariableMethodArgumentResolver
extends AbstractNamedValueSyncArgumentResolver {
    public PathVariableMethodArgumentResolver(@Nullable ConfigurableBeanFactory factory, ReactiveAdapterRegistry registry) {
        super(factory, registry);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.checkAnnotatedParamNoReactiveWrapper(parameter, PathVariable.class, this::singlePathVariable);
    }

    private boolean singlePathVariable(PathVariable pathVariable, Class<?> type) {
        return !Map.class.isAssignableFrom(type) || StringUtils.hasText((String)pathVariable.name());
    }

    @Override
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        PathVariable ann = (PathVariable)parameter.getParameterAnnotation(PathVariable.class);
        Assert.state((ann != null ? 1 : 0) != 0, (String)"No PathVariable annotation");
        return new PathVariableNamedValueInfo(ann);
    }

    @Override
    protected Object resolveNamedValue(String name, MethodParameter parameter, ServerWebExchange exchange2) {
        String attributeName = HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE;
        return ((Map)exchange2.getAttributeOrDefault(attributeName, Collections.emptyMap())).get(name);
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) {
        throw new ServerErrorException(name, parameter, null);
    }

    @Override
    protected void handleResolvedValue(@Nullable Object arg, String name, MethodParameter parameter, Model model, ServerWebExchange exchange2) {
    }

    private static class PathVariableNamedValueInfo
    extends AbstractNamedValueArgumentResolver.NamedValueInfo {
        public PathVariableNamedValueInfo(PathVariable annotation) {
            super(annotation.name(), annotation.required(), "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
        }
    }
}

