/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.ResourceHttpMessageWriter;
import org.springframework.http.server.PathContainer;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.resource.DefaultResourceResolverChain;
import org.springframework.web.reactive.resource.DefaultResourceTransformerChain;
import org.springframework.web.reactive.resource.HttpResource;
import org.springframework.web.reactive.resource.NoResourceFoundException;
import org.springframework.web.reactive.resource.PathResourceResolver;
import org.springframework.web.reactive.resource.ResourceHandlerUtils;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.reactive.resource.ResourceTransformer;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import org.springframework.web.util.pattern.PathPattern;
import reactor.core.publisher.Mono;

public class ResourceWebHandler
implements WebHandler,
InitializingBean {
    private static final Set<HttpMethod> SUPPORTED_METHODS = Set.of(HttpMethod.GET, HttpMethod.HEAD);
    private static final Log logger = LogFactory.getLog(ResourceWebHandler.class);
    private @Nullable ResourceLoader resourceLoader;
    private final List<String> locationValues = new ArrayList<String>(4);
    private final List<Resource> locationResources = new ArrayList<Resource>(4);
    private final List<Resource> locationsToUse = new ArrayList<Resource>(4);
    private final List<ResourceResolver> resourceResolvers = new ArrayList<ResourceResolver>(4);
    private final List<ResourceTransformer> resourceTransformers = new ArrayList<ResourceTransformer>(4);
    private @Nullable ResourceResolverChain resolverChain;
    private @Nullable ResourceTransformerChain transformerChain;
    private @Nullable CacheControl cacheControl;
    private @Nullable ResourceHttpMessageWriter resourceHttpMessageWriter;
    private @Nullable Map<String, MediaType> mediaTypes;
    private boolean useLastModified = true;
    private @Nullable Function<Resource, String> etagGenerator;
    private boolean optimizeLocations = false;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setLocationValues(List<String> locationValues) {
        Assert.notNull(locationValues, (String)"Location values list must not be null");
        this.locationValues.clear();
        this.locationValues.addAll(locationValues);
    }

    public List<String> getLocationValues() {
        return this.locationValues;
    }

    public void setLocations(@Nullable List<Resource> locations) {
        this.locationResources.clear();
        if (locations != null) {
            for (Resource location : locations) {
                ResourceHandlerUtils.assertResourceLocation(location);
                this.locationResources.add(location);
            }
        }
    }

    public List<Resource> getLocations() {
        if (this.locationsToUse.isEmpty()) {
            return this.locationResources;
        }
        return this.locationsToUse;
    }

    public void setResourceResolvers(@Nullable List<ResourceResolver> resourceResolvers) {
        this.resourceResolvers.clear();
        if (resourceResolvers != null) {
            this.resourceResolvers.addAll(resourceResolvers);
        }
    }

    public List<ResourceResolver> getResourceResolvers() {
        return this.resourceResolvers;
    }

    public void setResourceTransformers(@Nullable List<ResourceTransformer> resourceTransformers) {
        this.resourceTransformers.clear();
        if (resourceTransformers != null) {
            this.resourceTransformers.addAll(resourceTransformers);
        }
    }

    public List<ResourceTransformer> getResourceTransformers() {
        return this.resourceTransformers;
    }

    public void setResourceHttpMessageWriter(@Nullable ResourceHttpMessageWriter httpMessageWriter) {
        this.resourceHttpMessageWriter = httpMessageWriter;
    }

    public @Nullable ResourceHttpMessageWriter getResourceHttpMessageWriter() {
        return this.resourceHttpMessageWriter;
    }

    public void setCacheControl(@Nullable CacheControl cacheControl) {
        this.cacheControl = cacheControl;
    }

    public @Nullable CacheControl getCacheControl() {
        return this.cacheControl;
    }

    public void setUseLastModified(boolean useLastModified) {
        this.useLastModified = useLastModified;
    }

    public boolean isUseLastModified() {
        return this.useLastModified;
    }

    public void setEtagGenerator(@Nullable Function<Resource, String> etagGenerator) {
        this.etagGenerator = etagGenerator;
    }

    public @Nullable Function<Resource, String> getEtagGenerator() {
        return this.etagGenerator;
    }

    public void setOptimizeLocations(boolean optimizeLocations) {
        this.optimizeLocations = optimizeLocations;
    }

    public boolean isOptimizeLocations() {
        return this.optimizeLocations;
    }

    public void setMediaTypes(Map<String, MediaType> mediaTypes) {
        if (this.mediaTypes == null) {
            this.mediaTypes = new HashMap<String, MediaType>(mediaTypes.size());
        }
        mediaTypes.forEach((ext, type) -> this.mediaTypes.put(ext.toLowerCase(Locale.ROOT), (MediaType)type));
    }

    public Map<String, MediaType> getMediaTypes() {
        return this.mediaTypes != null ? this.mediaTypes : Collections.emptyMap();
    }

    public void afterPropertiesSet() throws Exception {
        this.resolveResourceLocations();
        if (this.resourceResolvers.isEmpty()) {
            this.resourceResolvers.add(new PathResourceResolver());
        }
        this.initAllowedLocations();
        if (this.getResourceHttpMessageWriter() == null) {
            this.resourceHttpMessageWriter = new ResourceHttpMessageWriter();
        }
        this.resolverChain = new DefaultResourceResolverChain(this.resourceResolvers);
        this.transformerChain = new DefaultResourceTransformerChain(this.resolverChain, this.resourceTransformers);
    }

    private void resolveResourceLocations() {
        List<Resource> result = new ArrayList<Resource>(this.locationResources);
        if (!this.locationValues.isEmpty()) {
            Assert.notNull((Object)this.resourceLoader, (String)"ResourceLoader is required when \"locationValues\" are configured.");
            Assert.isTrue((boolean)CollectionUtils.isEmpty(this.locationResources), (String)"Please set either Resource-based \"locations\" or String-based \"locationValues\", but not both.");
            for (String location : this.locationValues) {
                location = ResourceHandlerUtils.initLocationPath(location);
                result.add(this.resourceLoader.getResource(location));
            }
        }
        if (this.isOptimizeLocations()) {
            result = result.stream().filter(Resource::exists).toList();
        }
        this.locationsToUse.clear();
        this.locationsToUse.addAll(result);
    }

    protected void initAllowedLocations() {
        if (CollectionUtils.isEmpty(this.getLocations())) {
            return;
        }
        for (int i2 = this.getResourceResolvers().size() - 1; i2 >= 0; --i2) {
            ResourceResolver resourceResolver = this.getResourceResolvers().get(i2);
            if (!(resourceResolver instanceof PathResourceResolver)) continue;
            PathResourceResolver resolver = (PathResourceResolver)resourceResolver;
            if (!ObjectUtils.isEmpty((Object[])resolver.getAllowedLocations())) break;
            resolver.setAllowedLocations(this.getLocations().toArray(new Resource[0]));
            break;
        }
    }

    public Mono<Void> handle(ServerWebExchange exchange2) {
        return this.getResource(exchange2).switchIfEmpty(Mono.defer(() -> {
            logger.debug((Object)(exchange2.getLogPrefix() + "Resource not found"));
            return Mono.error((Throwable)((Object)new NoResourceFoundException(this.getResourcePath(exchange2))));
        })).flatMap(resource -> {
            try {
                Instant lastModified;
                if (HttpMethod.OPTIONS.equals((Object)exchange2.getRequest().getMethod())) {
                    exchange2.getResponse().getHeaders().add("Allow", "GET,HEAD,OPTIONS");
                    return Mono.empty();
                }
                HttpMethod httpMethod = exchange2.getRequest().getMethod();
                if (!SUPPORTED_METHODS.contains(httpMethod)) {
                    return Mono.error((Throwable)new MethodNotAllowedException(exchange2.getRequest().getMethod(), SUPPORTED_METHODS));
                }
                String eTagValue = this.getEtagGenerator() != null ? this.getEtagGenerator().apply((Resource)resource) : null;
                Instant instant = lastModified = this.isUseLastModified() ? Instant.ofEpochMilli(resource.lastModified()) : Instant.MIN;
                if (exchange2.checkNotModified(eTagValue, lastModified)) {
                    logger.trace((Object)(exchange2.getLogPrefix() + "Resource not modified"));
                    return Mono.empty();
                }
                CacheControl cacheControl = this.getCacheControl();
                if (cacheControl != null) {
                    exchange2.getResponse().getHeaders().setCacheControl(cacheControl);
                }
                MediaType mediaType = this.getMediaType((Resource)resource);
                this.setHeaders(exchange2, (Resource)resource, mediaType);
                ResourceHttpMessageWriter writer = this.getResourceHttpMessageWriter();
                Assert.state((writer != null ? 1 : 0) != 0, (String)"No ResourceHttpMessageWriter");
                if (HttpMethod.HEAD == httpMethod) {
                    return writer.addDefaultHeaders((ReactiveHttpOutputMessage)exchange2.getResponse(), resource, mediaType, Hints.from((String)Hints.LOG_PREFIX_HINT, (Object)exchange2.getLogPrefix())).then(exchange2.getResponse().setComplete());
                }
                return writer.write((Publisher)Mono.just((Object)resource), null, ResolvableType.forClass(Resource.class), mediaType, exchange2.getRequest(), exchange2.getResponse(), Hints.from((String)Hints.LOG_PREFIX_HINT, (Object)exchange2.getLogPrefix()));
            }
            catch (IOException ex) {
                return Mono.error((Throwable)ex);
            }
        });
    }

    protected Mono<Resource> getResource(ServerWebExchange exchange2) {
        String rawPath = this.getResourcePath(exchange2);
        String path = this.processPath(rawPath);
        if (ResourceHandlerUtils.shouldIgnoreInputPath(path) || this.isInvalidPath(path)) {
            return Mono.empty();
        }
        Assert.state((this.resolverChain != null ? 1 : 0) != 0, (String)"ResourceResolverChain not initialized");
        Assert.state((this.transformerChain != null ? 1 : 0) != 0, (String)"ResourceTransformerChain not initialized");
        return this.resolverChain.resolveResource(exchange2, path, this.getLocations()).flatMap(resource -> this.transformerChain.transform(exchange2, (Resource)resource));
    }

    private String getResourcePath(ServerWebExchange exchange2) {
        PathPattern pattern = (PathPattern)exchange2.getRequiredAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (!pattern.hasPatternSyntax()) {
            return pattern.getPatternString();
        }
        PathContainer pathWithinHandler = (PathContainer)exchange2.getRequiredAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        return pathWithinHandler.value();
    }

    protected String processPath(String path) {
        return ResourceHandlerUtils.normalizeInputPath(path);
    }

    protected boolean isInvalidPath(String path) {
        return false;
    }

    private @Nullable MediaType getMediaType(Resource resource) {
        List mediaTypes;
        String ext;
        MediaType mediaType = null;
        String filename = resource.getFilename();
        if (!CollectionUtils.isEmpty(this.mediaTypes) && (ext = StringUtils.getFilenameExtension((String)filename)) != null) {
            mediaType = this.mediaTypes.get(ext.toLowerCase(Locale.ROOT));
        }
        if (mediaType == null && !CollectionUtils.isEmpty((Collection)(mediaTypes = MediaTypeFactory.getMediaTypes((String)filename)))) {
            mediaType = (MediaType)mediaTypes.get(0);
        }
        return mediaType;
    }

    protected void setHeaders(ServerWebExchange exchange2, Resource resource, @Nullable MediaType mediaType) throws IOException {
        HttpHeaders headers = exchange2.getResponse().getHeaders();
        long length = resource.contentLength();
        headers.setContentLength(length);
        if (mediaType != null) {
            headers.setContentType(mediaType);
        }
        if (resource instanceof HttpResource) {
            HttpResource httpResource = (HttpResource)resource;
            exchange2.getResponse().getHeaders().putAll(httpResource.getResponseHeaders());
        }
    }

    public String toString() {
        return "ResourceWebHandler " + this.locationToString(this.getLocations());
    }

    private String locationToString(List<Resource> locations) {
        return locations.toString().replaceAll("class path resource", "classpath").replaceAll("ServletContext resource", "ServletContext");
    }
}

