/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ExtendedWebExchangeDataBinder
extends WebExchangeDataBinder {
    private static final Set<String> FILTERED_HEADER_NAMES = Set.of("accept", "authorization", "connection", "cookie", "from", "host", "origin", "priority", "range", "referer", "upgrade");
    private Predicate<String> headerPredicate = name -> !FILTERED_HEADER_NAMES.contains(name.toLowerCase(Locale.ROOT));

    public ExtendedWebExchangeDataBinder(@Nullable Object target, String objectName) {
        super(target, objectName);
    }

    public void addHeaderPredicate(Predicate<String> headerPredicate) {
        this.headerPredicate = this.headerPredicate.and(headerPredicate);
    }

    public void setHeaderPredicate(Predicate<String> headerPredicate) {
        this.headerPredicate = headerPredicate;
    }

    public Mono<Map<String, Object>> getValuesToBind(ServerWebExchange exchange2) {
        return super.getValuesToBind(exchange2).doOnNext(map -> {
            Map vars = (Map)exchange2.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            if (!CollectionUtils.isEmpty((Map)vars)) {
                vars.forEach((key, value) -> ExtendedWebExchangeDataBinder.addValueIfNotPresent(map, "URI variable", key, value));
            }
            HttpHeaders headers = exchange2.getRequest().getHeaders();
            for (Map.Entry entry : headers.headerSet()) {
                List values;
                String name = (String)entry.getKey();
                if (!this.headerPredicate.test((String)entry.getKey()) || CollectionUtils.isEmpty((Collection)(values = (List)entry.getValue()))) continue;
                ExtendedWebExchangeDataBinder.addValueIfNotPresent(map, "Header", name, values.size() == 1 ? values.get(0) : values);
                name = StringUtils.uncapitalize((String)((String)entry.getKey()).replace("-", ""));
                ExtendedWebExchangeDataBinder.addValueIfNotPresent(map, "Header", name, values.size() == 1 ? values.get(0) : values);
            }
        });
    }

    private static void addValueIfNotPresent(Map<String, Object> map, String label, String name, @Nullable Object value) {
        if (value != null) {
            if (map.containsKey(name)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(label + " '" + name + "' overridden by request bind value."));
                }
            } else {
                map.put(name, value);
            }
        }
    }
}

