/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;
import org.springframework.web.portlet.mvc.AbstractController;

public class PortletWrappingController
extends AbstractController
implements BeanNameAware,
InitializingBean,
DisposableBean,
PortletContextAware,
PortletConfigAware {
    private boolean useSharedPortletConfig = true;
    private PortletContext portletContext;
    private PortletConfig portletConfig;
    private Class portletClass;
    private String portletName;
    private Properties initParameters = new Properties();
    private String beanName;
    private Portlet portletInstance;

    public void setUseSharedPortletConfig(boolean useSharedPortletConfig) {
        this.useSharedPortletConfig = useSharedPortletConfig;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void setPortletClass(Class portletClass) {
        this.portletClass = portletClass;
    }

    public void setPortletName(String portletName) {
        this.portletName = portletName;
    }

    public void setInitParameters(Properties initParameters) {
        this.initParameters = initParameters;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void afterPropertiesSet() throws Exception {
        PortletConfig config;
        if (this.portletClass == null) {
            throw new IllegalArgumentException("portletClass is required");
        }
        if (!Portlet.class.isAssignableFrom(this.portletClass)) {
            throw new IllegalArgumentException("portletClass [" + this.portletClass.getName() + "] needs to implement interface [javax.portlet.Portlet]");
        }
        if (this.portletName == null) {
            this.portletName = this.beanName;
        }
        if ((config = this.portletConfig) == null || !this.useSharedPortletConfig) {
            config = new DelegatingPortletConfig();
        }
        this.portletInstance = (Portlet)this.portletClass.newInstance();
        this.portletInstance.init(config);
    }

    protected void handleActionRequestInternal(ActionRequest request, ActionResponse response) throws Exception {
        this.portletInstance.processAction(request, response);
    }

    protected ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        this.portletInstance.render(request, response);
        return null;
    }

    public void destroy() {
        this.portletInstance.destroy();
    }

    private class DelegatingPortletConfig
    implements PortletConfig {
        private DelegatingPortletConfig() {
        }

        public String getPortletName() {
            return PortletWrappingController.this.portletName;
        }

        public PortletContext getPortletContext() {
            return PortletWrappingController.this.portletContext;
        }

        public String getInitParameter(String paramName) {
            return PortletWrappingController.this.initParameters.getProperty(paramName);
        }

        public Enumeration getInitParameterNames() {
            return PortletWrappingController.this.initParameters.keys();
        }

        public ResourceBundle getResourceBundle(Locale locale) {
            return PortletWrappingController.this.portletConfig != null ? PortletWrappingController.this.portletConfig.getResourceBundle(locale) : null;
        }
    }
}

