/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.jasperreports;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataSourceProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRBshCompiler;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.Resource;
import org.springframework.ui.jasperreports.JasperReportsUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public abstract class AbstractJasperReportsView
extends AbstractUrlBasedView {
    protected static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_DISPOSITION_INLINE = "inline";
    private String reportDataKey;
    private Properties subReportUrls;
    private String[] subReportDataKeys;
    private JasperReport report;
    private Map subReports;
    private Properties headers;
    private Map exporterParameters;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$JRExporterParameter;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$JRDataSource;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$JRDataSourceProvider;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public void setReportDataKey(String reportDataKey) {
        this.reportDataKey = reportDataKey;
    }

    public void setSubReportUrls(Properties subReports) {
        this.subReportUrls = subReports;
    }

    public void setSubReportDataKeys(String[] subReportDataKeys) {
        this.subReportDataKeys = subReportDataKeys;
    }

    public void setHeaders(Properties headers) {
        this.headers = headers;
    }

    public void setExporterParameters(Map parameters) {
        this.exporterParameters = new HashMap(parameters.size());
        Iterator it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String fieldName = (String)entry.getKey();
            JRExporterParameter parameter = this.convertToExporterParameter(fieldName);
            this.exporterParameters.put(parameter, entry.getValue());
        }
    }

    protected Map getExporterParameters() {
        return this.exporterParameters;
    }

    protected void initApplicationContext() throws ApplicationContextException {
        super.initApplicationContext();
        Resource mainReport = this.getApplicationContext().getResource(this.getUrl());
        this.report = this.loadReport(mainReport);
        if (this.subReportUrls != null) {
            if (this.subReportDataKeys != null && this.subReportDataKeys.length > 0 && this.reportDataKey == null) {
                throw new ApplicationContextException("'reportDataKey' for main report is required when specifying a value for 'subReportDataKeys'");
            }
            this.subReports = new HashMap(this.subReportUrls.size());
            Enumeration<?> urls = this.subReportUrls.propertyNames();
            while (urls.hasMoreElements()) {
                String key = (String)urls.nextElement();
                String path = this.subReportUrls.getProperty(key);
                Resource resource = this.getApplicationContext().getResource(path);
                this.subReports.put(key, this.loadReport(resource));
            }
        }
        if (this.headers == null) {
            this.headers = new Properties();
        }
        if (!this.headers.containsKey(HEADER_CONTENT_DISPOSITION)) {
            this.headers.setProperty(HEADER_CONTENT_DISPOSITION, CONTENT_DISPOSITION_INLINE);
        }
    }

    protected JRExporterParameter convertToExporterParameter(String fqFieldName) {
        int index = fqFieldName.lastIndexOf(46);
        if (index == -1 || index == fqFieldName.length()) {
            throw new IllegalArgumentException("Parameter name [" + fqFieldName + "] is not a valid static field. " + "The parameter name must map to a static field such as " + "net.sf.jasperreports.engine.export.JRHtmlExporterParameter.IMAGES_URI");
        }
        String className = fqFieldName.substring(0, index);
        String fieldName = fqFieldName.substring(index + 1);
        try {
            Class cls = ClassUtils.forName((String)className);
            Field field = cls.getField(fieldName);
            if ((class$net$sf$jasperreports$engine$JRExporterParameter == null ? (class$net$sf$jasperreports$engine$JRExporterParameter = AbstractJasperReportsView.class$("net.sf.jasperreports.engine.JRExporterParameter")) : class$net$sf$jasperreports$engine$JRExporterParameter).isAssignableFrom(field.getType())) {
                try {
                    return (JRExporterParameter)field.get(null);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalArgumentException("Unable to access field [" + fieldName + "] of class [" + className + "]." + " Check that it is static and accessible.");
                }
            }
            throw new IllegalArgumentException("Field [" + fieldName + "] on class [" + className + "] is not assignable from JRExporterParameter - check the type of this field.");
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Class [" + className + "] in key [" + fqFieldName + "] could not be found.");
        }
        catch (NoSuchFieldException ex) {
            throw new IllegalArgumentException("Field [" + fieldName + "] in key [" + fqFieldName + "] could not be found on class [" + className + "].");
        }
    }

    private JasperReport loadReport(Resource resource) throws ApplicationContextException {
        try {
            String fileName = resource.getFilename();
            if (fileName.endsWith(".jasper")) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Loading pre-compiled Jasper Report from " + resource));
                }
                return (JasperReport)JRLoader.loadObject((InputStream)resource.getInputStream());
            }
            if (fileName.endsWith(".jrxml")) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Compiling Jasper Report loaded from " + resource));
                }
                JasperDesign design = JRXmlLoader.load((InputStream)resource.getInputStream());
                return this.getReportCompiler().compileReport(design);
            }
            throw new IllegalArgumentException("Report URL [" + this.getUrl() + "] must end in either .jasper or .jrxml");
        }
        catch (IOException ex) {
            throw new ApplicationContextException("Could not load JasperReports report for URL [" + this.getUrl() + "]", (Throwable)ex);
        }
        catch (JRException ex) {
            throw new ApplicationContextException("Could not parse JasperReports report for URL [" + this.getUrl() + "]", (Throwable)ex);
        }
    }

    protected JRCompiler getReportCompiler() {
        return new JRBshCompiler();
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType(this.getContentType());
        JRDataSource dataSource = this.getReportData(model);
        if (this.subReports != null) {
            model.putAll(this.subReports);
            if (this.subReportDataKeys != null) {
                for (int i = 0; i < this.subReportDataKeys.length; ++i) {
                    String key = this.subReportDataKeys[i];
                    model.put(key, this.convertReportData(model.get(key)));
                }
            }
        }
        this.populateHeaders(response);
        this.renderReport(this.report, model, dataSource, response);
    }

    private void populateHeaders(HttpServletResponse response) {
        Enumeration<?> en = this.headers.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            response.addHeader(key, this.headers.getProperty(key));
        }
    }

    protected JRDataSource getReportData(Map model) throws IllegalArgumentException {
        if (this.reportDataKey != null) {
            Object value = model.get(this.reportDataKey);
            return this.convertReportData(value);
        }
        Object value = CollectionUtils.findValueOfType(model.values(), (Class[])this.getReportDataTypes());
        if (value != null) {
            return this.convertReportData(value);
        }
        throw new IllegalArgumentException("No report data supplied in model " + model);
    }

    protected JRDataSource convertReportData(Object value) throws IllegalArgumentException {
        if (value instanceof JRDataSourceProvider) {
            try {
                return ((JRDataSourceProvider)value).create(this.report);
            }
            catch (JRException ex) {
                throw new IllegalArgumentException("Supplied JRDataSourceProvider is invalid: " + (Object)((Object)ex));
            }
        }
        return JasperReportsUtils.convertReportData((Object)value);
    }

    protected Class[] getReportDataTypes() {
        return new Class[]{class$net$sf$jasperreports$engine$JRDataSource == null ? (class$net$sf$jasperreports$engine$JRDataSource = AbstractJasperReportsView.class$("net.sf.jasperreports.engine.JRDataSource")) : class$net$sf$jasperreports$engine$JRDataSource, class$net$sf$jasperreports$engine$JRDataSourceProvider == null ? (class$net$sf$jasperreports$engine$JRDataSourceProvider = AbstractJasperReportsView.class$("net.sf.jasperreports.engine.JRDataSourceProvider")) : class$net$sf$jasperreports$engine$JRDataSourceProvider, class$java$util$Collection == null ? (class$java$util$Collection = AbstractJasperReportsView.class$("java.util.Collection")) : class$java$util$Collection, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AbstractJasperReportsView.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object};
    }

    protected JasperReport getReport() {
        return this.report;
    }

    protected abstract void renderReport(JasperReport var1, Map var2, JRDataSource var3, HttpServletResponse var4) throws Exception;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

