/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.ContextExposingHttpServletRequest;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.util.WebUtils;

public class InternalResourceView
extends AbstractUrlBasedView {
    private static final String DISPATCHED_PATH_ATTRIBUTE = InternalResourceView.class.getName() + ".DISPATCHED_PATH";
    private boolean alwaysInclude = false;
    private Boolean exposeForwardAttributes;
    private boolean exposeContextBeansAsAttributes = false;
    private boolean preventDispatchLoop = false;

    public InternalResourceView() {
    }

    public InternalResourceView(String url) {
        super(url);
    }

    public InternalResourceView(String url, boolean alwaysInclude) {
        super(url);
        this.alwaysInclude = alwaysInclude;
    }

    public void setAlwaysInclude(boolean alwaysInclude) {
        this.alwaysInclude = alwaysInclude;
    }

    public void setExposeForwardAttributes(boolean exposeForwardAttributes) {
        this.exposeForwardAttributes = exposeForwardAttributes;
    }

    public void setExposeContextBeansAsAttributes(boolean exposeContextBeansAsAttributes) {
        this.exposeContextBeansAsAttributes = exposeContextBeansAsAttributes;
    }

    public void setPreventDispatchLoop(boolean preventDispatchLoop) {
        this.preventDispatchLoop = preventDispatchLoop;
    }

    protected void initServletContext(ServletContext sc) {
        if (this.exposeForwardAttributes == null && sc.getMajorVersion() == 2 && sc.getMinorVersion() < 5) {
            this.exposeForwardAttributes = Boolean.TRUE;
        }
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpServletRequest requestToExpose = this.getRequestToExpose(request);
        this.exposeModelAsRequestAttributes(model, requestToExpose);
        this.exposeHelpers(requestToExpose);
        String dispatcherPath = this.prepareForRendering(requestToExpose, response);
        RequestDispatcher rd = requestToExpose.getRequestDispatcher(dispatcherPath);
        if (rd == null) {
            throw new ServletException("Could not get RequestDispatcher for [" + this.getUrl() + "]: check that this file exists within your WAR");
        }
        if (this.useInclude(requestToExpose, response)) {
            response.setContentType(this.getContentType());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Including resource [" + this.getUrl() + "] in InternalResourceView '" + this.getBeanName() + "'"));
            }
            rd.include((ServletRequest)requestToExpose, (ServletResponse)response);
        } else {
            this.exposeForwardRequestAttributes(requestToExpose);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Forwarding to resource [" + this.getUrl() + "] in InternalResourceView '" + this.getBeanName() + "'"));
            }
            rd.forward((ServletRequest)requestToExpose, (ServletResponse)response);
        }
    }

    protected void exposeHelpers(HttpServletRequest request) throws Exception {
    }

    protected String prepareForRendering(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String path = this.getUrl();
        if (this.preventDispatchLoop) {
            String previousPath = (String)request.getAttribute(DISPATCHED_PATH_ATTRIBUTE);
            String uri = request.getRequestURI();
            if (path.equals(previousPath)) {
                throw new ServletException("Circular view path [" + path + "]: already dispatched to this " + "view path within the same request [" + uri + "]. Check your ViewResolver setup! " + "(Hint: This may be the result of an unspecified view, due to default view name generation.)");
            }
            if (path.startsWith("/") ? uri.equals(path) : uri.equals(StringUtils.applyRelativePath((String)uri, (String)path))) {
                throw new ServletException("Circular view path [" + path + "]: would dispatch back " + "to the current handler URL [" + uri + "] again. Check your ViewResolver setup! " + "(Hint: This may be the result of an unspecified view, due to default view name generation.)");
            }
            request.setAttribute(DISPATCHED_PATH_ATTRIBUTE, (Object)path);
        }
        return path;
    }

    protected HttpServletRequest getRequestToExpose(HttpServletRequest originalRequest) {
        if (this.exposeContextBeansAsAttributes && !(originalRequest instanceof ContextExposingHttpServletRequest)) {
            return new ContextExposingHttpServletRequest(originalRequest, this.getWebApplicationContext());
        }
        return originalRequest;
    }

    protected boolean useInclude(HttpServletRequest request, HttpServletResponse response) {
        return this.alwaysInclude || WebUtils.isIncludeRequest((ServletRequest)request) || response.isCommitted();
    }

    protected void exposeForwardRequestAttributes(HttpServletRequest request) {
        if (this.exposeForwardAttributes != null && this.exposeForwardAttributes.booleanValue()) {
            WebUtils.exposeForwardRequestAttributes((HttpServletRequest)request);
        }
    }
}

