/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.Map;
import javax.servlet.jsp.JspException;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.SelectedValueComparator;
import org.springframework.web.servlet.tags.form.TagWriter;
import org.springframework.web.servlet.tags.form.ValueFormatter;

class OptionWriter {
    private final Object optionSource;
    private final BindStatus bindStatus;
    private final String valueProperty;
    private final String labelProperty;
    private final boolean htmlEscape;

    public OptionWriter(Object optionSource, BindStatus bindStatus, String valueProperty, String labelProperty, boolean htmlEscape) {
        Assert.notNull((Object)optionSource, (String)"'optionSource' must not be null");
        Assert.notNull((Object)bindStatus, (String)"'bindStatus' must not be null");
        this.optionSource = optionSource;
        this.bindStatus = bindStatus;
        this.valueProperty = valueProperty;
        this.labelProperty = labelProperty;
        this.htmlEscape = htmlEscape;
    }

    public void writeOptions(TagWriter tagWriter) throws JspException {
        if (this.optionSource.getClass().isArray()) {
            this.renderFromArray(tagWriter);
        } else if (this.optionSource instanceof Collection) {
            this.renderFromCollection(tagWriter);
        } else if (this.optionSource instanceof Map) {
            this.renderFromMap(tagWriter);
        } else if (this.optionSource instanceof Class && this.optionSource.getClass().isEnum()) {
            this.renderFromEnum(tagWriter);
        } else {
            throw new JspException("Type [" + this.optionSource.getClass().getName() + "] is not valid for option items");
        }
    }

    private void renderFromArray(TagWriter tagWriter) throws JspException {
        this.doRenderFromCollection(CollectionUtils.arrayToList((Object)this.optionSource), tagWriter);
    }

    private void renderFromMap(TagWriter tagWriter) throws JspException {
        Map optionMap = (Map)this.optionSource;
        for (Map.Entry entry : optionMap.entrySet()) {
            Object mapKey = entry.getKey();
            Object mapValue = entry.getValue();
            BeanWrapper mapKeyWrapper = PropertyAccessorFactory.forBeanPropertyAccess(mapKey);
            BeanWrapper mapValueWrapper = PropertyAccessorFactory.forBeanPropertyAccess(mapValue);
            String renderValue = this.valueProperty != null ? mapKeyWrapper.getPropertyValue(this.valueProperty) : mapKey.toString();
            String renderLabel = this.labelProperty != null ? mapValueWrapper.getPropertyValue(this.labelProperty) : mapValue.toString();
            this.renderOption(tagWriter, mapKey, renderValue, renderLabel);
        }
    }

    private void renderFromCollection(TagWriter tagWriter) throws JspException {
        this.doRenderFromCollection((Collection)this.optionSource, tagWriter);
    }

    private void renderFromEnum(TagWriter tagWriter) throws JspException {
        this.doRenderFromCollection(CollectionUtils.arrayToList(((Class)this.optionSource).getEnumConstants()), tagWriter);
    }

    private void doRenderFromCollection(Collection optionCollection, TagWriter tagWriter) throws JspException {
        for (Object item : optionCollection) {
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess(item);
            Object value = this.valueProperty != null ? wrapper.getPropertyValue(this.valueProperty) : (item instanceof Enum ? ((Enum)item).name() : item);
            Object label = this.labelProperty != null ? wrapper.getPropertyValue(this.labelProperty) : item;
            this.renderOption(tagWriter, item, value, label);
        }
    }

    private void renderOption(TagWriter tagWriter, Object item, Object value, Object label) throws JspException {
        tagWriter.startTag("option");
        this.writeCommonAttributes(tagWriter);
        String valueDisplayString = this.getDisplayString(value);
        String labelDisplayString = this.getDisplayString(label);
        tagWriter.writeAttribute("value", valueDisplayString);
        if (this.isOptionSelected(value) || value != item && this.isOptionSelected(item)) {
            tagWriter.writeAttribute("selected", "selected");
        }
        if (this.isOptionDisabled()) {
            tagWriter.writeAttribute("disabled", "disabled");
        }
        tagWriter.appendValue(labelDisplayString);
        tagWriter.endTag();
    }

    private String getDisplayString(Object value) {
        PropertyEditor editor = value != null ? this.bindStatus.findEditor(value.getClass()) : null;
        return ValueFormatter.getDisplayString(value, editor, this.htmlEscape);
    }

    private boolean isOptionSelected(Object resolvedValue) {
        return SelectedValueComparator.isSelected(this.bindStatus, resolvedValue);
    }

    protected boolean isOptionDisabled() throws JspException {
        return false;
    }

    protected void writeCommonAttributes(TagWriter tagWriter) throws JspException {
    }
}

