/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.ServletContextResourceLoader;

public class ServletContextResourcePatternResolver
extends PathMatchingResourcePatternResolver {
    public ServletContextResourcePatternResolver(ServletContext servletContext) {
        super(new ServletContextResourceLoader(servletContext));
    }

    public ServletContextResourcePatternResolver(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    protected Set doFindPathMatchingFileResources(Resource rootDirResource, String subPattern) throws IOException {
        ServletContextResource scResource;
        ServletContext sc;
        if (rootDirResource instanceof ServletContextResource && ((sc = (scResource = (ServletContextResource)rootDirResource).getServletContext()).getMajorVersion() > 2 || sc.getMajorVersion() == 2 && sc.getMinorVersion() > 2)) {
            String fullPattern = scResource.getPath() + subPattern;
            HashSet result = new HashSet();
            this.doRetrieveMatchingServletContextResources(sc, fullPattern, scResource.getPath(), result);
            return result;
        }
        return super.doFindPathMatchingFileResources(rootDirResource, subPattern);
    }

    protected void doRetrieveMatchingServletContextResources(ServletContext servletContext, String fullPattern, String dir, Set result) throws IOException {
        Set candidates = servletContext.getResourcePaths(dir);
        if (candidates != null) {
            boolean dirDepthNotFixed = fullPattern.indexOf("**") != -1;
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                int dirIndex;
                String currPath = (String)it.next();
                if (!currPath.startsWith(dir) && (dirIndex = currPath.indexOf(dir)) != -1) {
                    currPath = currPath.substring(dirIndex);
                }
                if (currPath.endsWith("/") && (dirDepthNotFixed || StringUtils.countOccurrencesOf(currPath, "/") < StringUtils.countOccurrencesOf(fullPattern, "/"))) {
                    this.doRetrieveMatchingServletContextResources(servletContext, fullPattern, currPath, result);
                }
                if (!this.getPathMatcher().match(fullPattern, currPath)) continue;
                result.add(new ServletContextResource(servletContext, currPath));
            }
        }
    }
}

