/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource;

import java.sql.Savepoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.SavepointManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.TransactionUsageException;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.util.ClassUtils;

public abstract class JdbcTransactionObjectSupport
implements SavepointManager,
SmartTransactionObject {
    private static final String SAVEPOINT_CLASS_NAME = "java.sql.Savepoint";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jdbc$datasource$JdbcTransactionObjectSupport == null ? (class$org$springframework$jdbc$datasource$JdbcTransactionObjectSupport = JdbcTransactionObjectSupport.class$("org.springframework.jdbc.datasource.JdbcTransactionObjectSupport")) : class$org$springframework$jdbc$datasource$JdbcTransactionObjectSupport));
    private static boolean savepointClassAvailable;
    private ConnectionHolder connectionHolder;
    private Integer previousIsolationLevel;
    private boolean savepointAllowed;
    static /* synthetic */ Class class$org$springframework$jdbc$datasource$JdbcTransactionObjectSupport;

    public void setConnectionHolder(ConnectionHolder connectionHolder) {
        this.connectionHolder = connectionHolder;
    }

    public ConnectionHolder getConnectionHolder() {
        return this.connectionHolder;
    }

    public boolean hasConnectionHolder() {
        return this.connectionHolder != null;
    }

    public void setPreviousIsolationLevel(Integer previousIsolationLevel) {
        this.previousIsolationLevel = previousIsolationLevel;
    }

    public Integer getPreviousIsolationLevel() {
        return this.previousIsolationLevel;
    }

    public void setSavepointAllowed(boolean savepointAllowed) {
        this.savepointAllowed = savepointAllowed;
    }

    public boolean isSavepointAllowed() {
        return this.savepointAllowed;
    }

    public Object createSavepoint() throws TransactionException {
        if (!savepointClassAvailable) {
            throw new NestedTransactionNotSupportedException("Cannot create a nested JDBC transaction because you are not running on JDK 1.4 or higher");
        }
        ConnectionHolder conHolder = this.getConnectionHolderForSavepoint();
        try {
            if (!conHolder.supportsSavepoints()) {
                throw new NestedTransactionNotSupportedException("Cannot create a nested transaction because savepoints are not supported by your JDBC driver");
            }
        }
        catch (Throwable ex) {
            throw new NestedTransactionNotSupportedException("Cannot create a nested transaction because your JDBC driver is not a JDBC 3.0 driver", ex);
        }
        try {
            return conHolder.createSavepoint();
        }
        catch (Throwable ex) {
            throw new CannotCreateTransactionException("Could not create JDBC savepoint", ex);
        }
    }

    public void rollbackToSavepoint(Object savepoint) throws TransactionException {
        try {
            this.getConnectionHolderForSavepoint().getConnection().rollback((Savepoint)savepoint);
        }
        catch (Throwable ex) {
            throw new TransactionSystemException("Could not roll back to JDBC savepoint", ex);
        }
    }

    public void releaseSavepoint(Object savepoint) throws TransactionException {
        try {
            this.getConnectionHolderForSavepoint().getConnection().releaseSavepoint((Savepoint)savepoint);
        }
        catch (Throwable ex) {
            logger.debug((Object)"Could not explicitly release JDBC savepoint", ex);
        }
    }

    protected ConnectionHolder getConnectionHolderForSavepoint() throws TransactionException {
        if (!this.isSavepointAllowed()) {
            throw new NestedTransactionNotSupportedException("Transaction manager does not allow nested transactions");
        }
        if (!this.hasConnectionHolder()) {
            throw new TransactionUsageException("Cannot create nested transaction if not exposing a JDBC transaction");
        }
        return this.getConnectionHolder();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (ClassUtils.isPresent(SAVEPOINT_CLASS_NAME)) {
            savepointClassAvailable = true;
            logger.info((Object)"JDBC 3.0 Savepoint class is available");
        } else {
            savepointClassAvailable = false;
            logger.info((Object)"JDBC 3.0 Savepoint class is not available");
        }
    }
}

