/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.support;

import org.springframework.aop.target.dynamic.BeanFactoryRefreshableTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;

public class RefreshableScriptTargetSource
extends BeanFactoryRefreshableTargetSource {
    private final ScriptSource scriptSource;
    private final boolean isFactoryBean;

    public RefreshableScriptTargetSource(BeanFactory beanFactory, String beanName, ScriptSource scriptSource, boolean isFactoryBean) {
        super(beanFactory, beanName);
        Assert.notNull(scriptSource, "ScriptSource must not be null");
        this.scriptSource = scriptSource;
        this.isFactoryBean = isFactoryBean;
    }

    protected boolean requiresRefresh() {
        return this.scriptSource.isModified();
    }

    protected Object obtainFreshBean(BeanFactory beanFactory, String beanName) {
        if (this.isFactoryBean) {
            beanName = "&" + beanName;
        }
        return super.obtainFreshBean(beanFactory, beanName);
    }
}

