/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.access;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.naming.NamingException;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.ejb.access.AbstractRemoteSlsbInvokerInterceptor;
import org.springframework.remoting.RemoteLookupFailureException;
import org.springframework.remoting.rmi.RmiClientInterceptorUtils;

public class SimpleRemoteSlsbInvokerInterceptor
extends AbstractRemoteSlsbInvokerInterceptor
implements DisposableBean {
    private boolean cacheSessionBean = false;
    private Object beanInstance;
    private final Object beanInstanceMonitor = new Object();

    public void setCacheSessionBean(boolean cacheSessionBean) {
        this.cacheSessionBean = cacheSessionBean;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object doInvoke(MethodInvocation invocation) throws Throwable {
        Object object;
        Object ejb = null;
        try {
            try {
                ejb = this.getSessionBeanInstance();
                object = RmiClientInterceptorUtils.invokeRemoteMethod(invocation, ejb);
                Object var7_6 = null;
            }
            catch (NamingException ex) {
                throw new RemoteLookupFailureException("Failed to locate remote EJB [" + this.getJndiName() + "]", ex);
            }
            catch (InvocationTargetException ex) {
                Throwable targetEx = ex.getTargetException();
                if (targetEx instanceof RemoteException) {
                    RemoteException rex = (RemoteException)targetEx;
                    throw RmiClientInterceptorUtils.convertRmiAccessException(invocation.getMethod(), rex, this.isConnectFailure(rex), this.getJndiName());
                }
                if (!(targetEx instanceof CreateException)) throw targetEx;
                throw RmiClientInterceptorUtils.convertRmiAccessException(invocation.getMethod(), targetEx, "Could not create remote EJB [" + this.getJndiName() + "]");
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!(ejb instanceof EJBObject)) throw throwable;
            this.releaseSessionBeanInstance((EJBObject)ejb);
            throw throwable;
        }
        if (!(ejb instanceof EJBObject)) return object;
        this.releaseSessionBeanInstance((EJBObject)ejb);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getSessionBeanInstance() throws NamingException, InvocationTargetException {
        if (this.cacheSessionBean) {
            Object object = this.beanInstanceMonitor;
            synchronized (object) {
                if (this.beanInstance == null) {
                    this.beanInstance = this.newSessionBeanInstance();
                }
                return this.beanInstance;
            }
        }
        return this.newSessionBeanInstance();
    }

    protected void releaseSessionBeanInstance(EJBObject ejb) {
        if (!this.cacheSessionBean) {
            this.removeSessionBeanInstance(ejb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshHome() throws NamingException {
        super.refreshHome();
        if (this.cacheSessionBean) {
            Object object = this.beanInstanceMonitor;
            synchronized (object) {
                this.beanInstance = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.cacheSessionBean) {
            Object object = this.beanInstanceMonitor;
            synchronized (object) {
                if (this.beanInstance instanceof EJBObject) {
                    this.removeSessionBeanInstance((EJBObject)this.beanInstance);
                }
            }
        }
    }
}

