/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import org.springsource.loaded.Constants;
import org.springsource.loaded.FieldMember;
import org.springsource.loaded.MethodMember;
import org.springsource.loaded.TypeDescriptor;
import org.springsource.loaded.Utils;
import sl.org.objectweb.asm.Label;
import sl.org.objectweb.asm.MethodAdapter;
import sl.org.objectweb.asm.MethodVisitor;

class MethodCopier
extends MethodAdapter
implements Constants {
    private boolean isInterface;
    private String descriptor;
    private TypeDescriptor typeDescriptor;
    private String classname;
    private String suffix;
    private boolean hasFieldsRequiringAccessors;

    public MethodCopier(MethodVisitor mv, boolean isInterface, String descriptor, TypeDescriptor typeDescriptor, String classname, String suffix) {
        super(mv);
        this.isInterface = isInterface;
        this.descriptor = descriptor;
        this.typeDescriptor = typeDescriptor;
        this.classname = classname;
        this.suffix = suffix;
        this.hasFieldsRequiringAccessors = this.typeDescriptor.getFieldsRequiringAccessors().length != 0;
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (index == 0 && name.equals("this")) {
            super.visitLocalVariable("thiz", desc, signature, start, end, index);
        } else {
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }
    }

    private FieldMember findFieldIfRequiresAccessorUsage(String owner, String name) {
        FieldMember[] fms;
        for (FieldMember fm : fms = this.typeDescriptor.getFieldsRequiringAccessors()) {
            if (!fm.getName().equals(name) || !owner.equals(this.classname) && !this.isOneOfOurSupertypes(owner)) continue;
            return fm;
        }
        return null;
    }

    private boolean isOneOfOurSupertypes(String type) {
        String stypeName = this.typeDescriptor.getSupertypeName();
        while (stypeName != null) {
            if (stypeName.equals(type)) {
                return true;
            }
            stypeName = this.typeDescriptor.getTypeRegistry().getDescriptorFor(stypeName).getSupertypeName();
        }
        return false;
    }

    private TypeDescriptor getType(String type) {
        TypeDescriptor typeDescriptor = this.typeDescriptor.getTypeRegistry().getDescriptorFor(type);
        return typeDescriptor;
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        FieldMember fm;
        if (this.hasFieldsRequiringAccessors && (fm = this.findFieldIfRequiresAccessorUsage(owner, name)) != null) {
            switch (opcode) {
                case 180: {
                    this.mv.visitMethodInsn(182, this.classname, Utils.getProtectedFieldGetterName(name), "()" + desc);
                    return;
                }
                case 181: {
                    this.mv.visitMethodInsn(182, this.classname, Utils.getProtectedFieldSetterName(name), "(" + desc + ")V");
                    return;
                }
                case 178: {
                    this.mv.visitMethodInsn(184, this.classname, Utils.getProtectedFieldGetterName(name), "()" + desc);
                    return;
                }
                case 179: {
                    this.mv.visitMethodInsn(184, this.classname, Utils.getProtectedFieldSetterName(name), "(" + desc + ")V");
                    return;
                }
            }
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        MethodMember mm;
        if (opcode == 183 && name.charAt(0) != '<' && !name.startsWith("r$")) {
            if (owner.equals(this.classname)) {
                String descriptor = Utils.insertExtraParameter(owner, desc);
                super.visitMethodInsn(184, Utils.getExecutorName(this.classname, this.suffix), name, descriptor);
                return;
            }
            TypeDescriptor supertypeDescriptor = this.getType(owner);
            MethodMember target = supertypeDescriptor.getByNameAndDescriptor(name + desc);
            if (target != null && target.isProtected()) {
                super.visitMethodInsn(183, this.classname, name + "_$superdispatcher$", desc);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc);
            }
            return;
        }
        boolean done = false;
        if (opcode == 184 && (mm = this.typeDescriptor.getByDescriptor(name, desc)) != null && mm.isPrivate()) {
            super.visitMethodInsn(184, Utils.getExecutorName(this.classname, this.suffix), name, desc);
            done = true;
        }
        if (!done) {
            super.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    @Override
    public void visitEnd() {
        if (this.isInterface) {
            this.createDummyMethodBody();
            super.visitEnd();
        }
    }

    private void createDummyMethodBody() {
        block7: {
            int descriptorSize;
            block8: {
                Utils.ReturnType returnType;
                block6: {
                    returnType = Utils.getReturnTypeDescriptor(this.descriptor);
                    descriptorSize = Utils.getSize(this.descriptor);
                    if (!returnType.isVoid()) break block6;
                    super.visitInsn(177);
                    super.visitMaxs(1, descriptorSize);
                    break block7;
                }
                if (!returnType.isPrimitive()) break block8;
                super.visitLdcInsn(0);
                switch (returnType.descriptor.charAt(0)) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        super.visitInsn(172);
                        super.visitMaxs(2, descriptorSize);
                        break block7;
                    }
                    case 'D': {
                        super.visitInsn(175);
                        super.visitMaxs(3, descriptorSize);
                        break block7;
                    }
                    case 'F': {
                        super.visitInsn(174);
                        super.visitMaxs(2, descriptorSize);
                        break block7;
                    }
                    case 'J': {
                        super.visitInsn(173);
                        super.visitMaxs(3, descriptorSize);
                        break block7;
                    }
                    default: {
                        throw new IllegalStateException(returnType.descriptor);
                    }
                }
            }
            super.visitInsn(1);
            super.visitInsn(176);
            super.visitMaxs(1, descriptorSize);
        }
    }
}

