/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.agent;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.TypeRegistry;
import org.springsource.loaded.agent.SpringLoadedPreProcessor;

public class ClassPreProcessorAgentAdapter
implements ClassFileTransformer {
    private static Logger log = Logger.getLogger(ClassPreProcessorAgentAdapter.class.getName());
    private static SpringLoadedPreProcessor preProcessor;
    private static ClassPreProcessorAgentAdapter instance;

    public ClassPreProcessorAgentAdapter() {
        instance = this;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytes) throws IllegalClassFormatException {
        try {
            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                log.info("> (loader=" + loader + " className=" + className + ", classBeingRedefined=" + classBeingRedefined + ", protectedDomain=" + (protectionDomain != null) + ", bytes= " + (bytes == null ? "null" : Integer.valueOf(bytes.length)));
            }
            if (classBeingRedefined != null) {
                TypeRegistry typeRegistry = TypeRegistry.getTypeRegistryFor(loader);
                if (typeRegistry == null) {
                    return null;
                }
                boolean isRTN = typeRegistry.isReloadableTypeName(className);
                if (isRTN) {
                    ReloadableType rtype = typeRegistry.getReloadableType(className, false);
                    if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                        log.info("Tricking HCR for " + className);
                    }
                    return rtype.bytesLoaded;
                }
                return null;
            }
            return preProcessor.preProcess(loader, className, protectionDomain, bytes);
        }
        catch (Throwable t) {
            new RuntimeException("Reloading agent exited via exception, please raise a jira", t).printStackTrace();
            return bytes;
        }
    }

    public static void reload(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] bytes) throws IllegalClassFormatException {
        instance.transform(loader, className, classBeingRedefined, protectionDomain, bytes);
    }

    static {
        try {
            preProcessor = new SpringLoadedPreProcessor();
            preProcessor.initialize();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("could not initialize JSR163 preprocessor due to: " + e.toString());
        }
    }
}

