/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.ri;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springsource.loaded.ri.Invoker;
import org.springsource.loaded.ri.MethodProvider;

public class GetMethodsLookup {
    public Collection<Invoker> lookup(MethodProvider methodProvider) {
        HashMap<String, Invoker> found = new HashMap<String, Invoker>();
        this.collectAll(methodProvider, found);
        return found.values();
    }

    private void collectAll(MethodProvider methodProvider, Map<String, Invoker> found) {
        MethodProvider[] itfs = methodProvider.getInterfaces();
        for (int i = itfs.length - 1; i >= 0; --i) {
            this.collectAll(itfs[i], found);
        }
        MethodProvider supr = methodProvider.getSuper();
        if (supr != null && !methodProvider.isInterface()) {
            this.collectAll(supr, found);
        }
        for (Invoker method : methodProvider.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            found.put(method.getName() + method.getMethodDescriptor(), method);
        }
    }
}

