/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.test.infra;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import org.springsource.loaded.Utils;
import org.springsource.loaded.test.infra.MethodPrinter;
import sl.org.objectweb.asm.AnnotationVisitor;
import sl.org.objectweb.asm.Attribute;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.ClassVisitor;
import sl.org.objectweb.asm.FieldVisitor;
import sl.org.objectweb.asm.MethodVisitor;
import sl.org.objectweb.asm.Opcodes;

public class ClassPrinter
implements ClassVisitor,
Opcodes {
    private PrintStream destination;
    private boolean includeBytecode;

    public static void main(String[] argv) throws Exception {
        ClassReader reader = new ClassReader(Utils.loadBytesFromStream(new FileInputStream(new File(argv[0]))));
        reader.accept(new ClassPrinter(System.out, true), 0);
    }

    public ClassPrinter(PrintStream destination) {
        this(destination, true);
    }

    public ClassPrinter(PrintStream destination, boolean includeBytecode) {
        this.destination = destination;
        this.includeBytecode = includeBytecode;
    }

    public static void print(String message, byte[] bytes) {
        System.out.println(message);
        ClassPrinter.print(bytes, true);
    }

    public static void print(byte[] bytes) {
        ClassPrinter.print(bytes, true);
    }

    public static void print(byte[] bytes, boolean includeBytecode) {
        ClassReader reader = new ClassReader(bytes);
        reader.accept(new ClassPrinter(System.out, includeBytecode), 0);
    }

    public static void print(PrintStream printStream, byte[] bytes, boolean includeBytecode) {
        ClassReader reader = new ClassReader(bytes);
        reader.accept(new ClassPrinter(printStream, includeBytecode), 0);
    }

    public static void print(String message, byte[] bytes, boolean includeBytecode) {
        System.out.println(message);
        ClassPrinter.print(bytes, includeBytecode);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.destination.println("CLASS: " + name + " v" + Integer.toString(version) + " " + this.toHex(access, 4) + "(" + this.toAccessForClass(access) + ") super " + superName + (interfaces == null || interfaces.length == 0 ? "" : " interfaces" + this.toString(interfaces)));
    }

    private String toString(Object[] os) {
        if (os == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : os) {
            sb.append(o).append(" ");
        }
        return sb.toString();
    }

    private String toAccessForClass(int flags) {
        StringBuilder sb = new StringBuilder();
        if ((flags & 1) != 0) {
            sb.append("public ");
        }
        if ((flags & 2) != 0) {
            sb.append("private ");
        }
        if ((flags & 4) != 0) {
            sb.append("protected ");
        }
        if ((flags & 8) != 0) {
            sb.append("static ");
        }
        if ((flags & 0x10) != 0) {
            sb.append("final ");
        }
        if ((flags & 0x20) != 0) {
            sb.append("synchronized ");
        }
        if ((flags & 0x40) != 0) {
            sb.append("bridge ");
        }
        if ((flags & 0x80) != 0) {
            sb.append("varargs ");
        }
        if ((flags & 0x100) != 0) {
            sb.append("native ");
        }
        if ((flags & 0x400) != 0) {
            sb.append("abstract ");
        }
        if ((flags & 0x1000) != 0) {
            sb.append("synthetic ");
        }
        if ((flags & 0x20000) != 0) {
            sb.append("deprecated ");
        }
        if ((flags & 0x200) != 0) {
            sb.append("interface ");
        }
        return sb.toString().trim();
    }

    public static String toAccessForMember(int flags) {
        StringBuilder sb = new StringBuilder();
        if ((flags & 1) != 0) {
            sb.append("public ");
        }
        if ((flags & 2) != 0) {
            sb.append("private ");
        }
        if ((flags & 8) != 0) {
            sb.append("static ");
        }
        if ((flags & 4) != 0) {
            sb.append("protected ");
        }
        if ((flags & 0x10) != 0) {
            sb.append("final ");
        }
        if ((flags & 0x20) != 0) {
            sb.append("super ");
        }
        if ((flags & 0x200) != 0) {
            sb.append("interface ");
        }
        if ((flags & 0x400) != 0) {
            sb.append("abstract ");
        }
        if ((flags & 0x1000) != 0) {
            sb.append("synthetic ");
        }
        if ((flags & 0x2000) != 0) {
            sb.append("annotation ");
        }
        if ((flags & 0x4000) != 0) {
            sb.append("enum ");
        }
        if ((flags & 0x20000) != 0) {
            sb.append("deprecated ");
        }
        return sb.toString().trim();
    }

    private String toHex(int i, int len) {
        StringBuilder sb = new StringBuilder("00000000");
        sb.append(Integer.toHexString(i));
        return "0x" + sb.substring(sb.length() - len);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.destination.print("ANNOTATION " + desc + " vis?" + visible + " VALUE ");
        return new AnnotationVisitorPrinter();
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public void visitEnd() {
        this.destination.println();
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append("FIELD " + this.toHex(access, 4) + "(" + ClassPrinter.toAccessForMember(access) + ") " + name + " " + desc + (signature != null ? " " + signature : ""));
        this.destination.println(sb.toString().trim());
        return null;
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.destination.println("INNERCLASS: " + name + " " + outerName + " " + innerName + " " + access);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        StringBuilder s = new StringBuilder();
        s.append("METHOD: " + this.toHex(access, 4) + "(" + ClassPrinter.toAccessForMember(access) + ") " + name + desc + " " + this.fromArray(exceptions));
        this.destination.println(s.toString().trim());
        return this.includeBytecode ? new MethodPrinter(this.destination) : null;
    }

    private String fromArray(Object[] os) {
        if (os == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : os) {
            sb.append(o).append(" ");
        }
        return sb.toString();
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        this.destination.println("OUTERCLASS: " + owner + " " + name + " " + desc);
    }

    @Override
    public void visitSource(String source, String debug) {
        this.destination.println("SOURCE: " + source + " " + debug);
    }

    class AnnotationVisitorPrinter
    implements AnnotationVisitor {
        AnnotationVisitorPrinter() {
        }

        @Override
        public void visit(String name, Object value) {
            ClassPrinter.this.destination.print(name + "=" + value + " ");
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            ClassPrinter.this.destination.print(name + "=" + desc + "." + value + " ");
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            ClassPrinter.this.destination.print(name + "=" + desc + " ");
            return new AnnotationVisitorPrinter();
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            ClassPrinter.this.destination.print(name + " ");
            return new AnnotationVisitorPrinter();
        }

        @Override
        public void visitEnd() {
            ClassPrinter.this.destination.println();
        }
    }
}

