/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoCallback;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.service.StateMachineSerialisationService;
import org.springframework.util.Assert;

public abstract class AbstractKryoStateMachineSerialisationService<S, E>
implements StateMachineSerialisationService<S, E> {
    protected final KryoPool pool;

    protected AbstractKryoStateMachineSerialisationService() {
        KryoFactory factory = new KryoFactory(){

            public Kryo create() {
                Kryo kryo = new Kryo();
                AbstractKryoStateMachineSerialisationService.this.configureKryoInstance(kryo);
                return kryo;
            }
        };
        this.pool = new KryoPool.Builder(factory).softReferences().build();
    }

    public byte[] serialiseStateMachineContext(StateMachineContext<S, E> context) throws Exception {
        return this.encode(context);
    }

    public StateMachineContext<S, E> deserialiseStateMachineContext(byte[] data) throws Exception {
        return this.decode(data, StateMachineContext.class);
    }

    protected abstract void doEncode(Kryo var1, Object var2, Output var3);

    protected abstract <T> T doDecode(Kryo var1, Input var2, Class<T> var3);

    protected abstract void configureKryoInstance(Kryo var1);

    private byte[] encode(Object object) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.encode(object, bos);
        byte[] bytes = bos.toByteArray();
        bos.close();
        return bytes;
    }

    private void encode(final Object object, OutputStream outputStream) throws IOException {
        Assert.notNull((Object)object, (String)"cannot encode a null object");
        Assert.notNull((Object)outputStream, (String)"'outputSteam' cannot be null");
        final Output output = outputStream instanceof Output ? (Output)outputStream : new Output(outputStream);
        this.pool.run((KryoCallback)new KryoCallback<Void>(){

            public Void execute(Kryo kryo) {
                AbstractKryoStateMachineSerialisationService.this.doEncode(kryo, object, output);
                return null;
            }
        });
        output.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T decode(byte[] bytes, Class<T> type) throws IOException {
        Assert.notNull((Object)bytes, (String)"'bytes' cannot be null");
        try (Input input = new Input(bytes);){
            T t = this.decode((InputStream)input, type);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T decode(InputStream inputStream, final Class<T> type) throws IOException {
        Assert.notNull((Object)inputStream, (String)"'inputStream' cannot be null");
        Assert.notNull(type, (String)"'type' cannot be null");
        Object result = null;
        try (final Input input = inputStream instanceof Input ? (Input)inputStream : new Input(inputStream);){
            result = this.pool.run(new KryoCallback<T>(){

                public T execute(Kryo kryo) {
                    return AbstractKryoStateMachineSerialisationService.this.doDecode(kryo, input, type);
                }
            });
        }
        return (T)result;
    }
}

